import asyncio
import concurrent
import requests
import re

# We can read wikipedia page and parse it
# Note that this function blocks, thus we should not call it directly

# matcher=re.compile('"/wiki/[a-zA-Z0-9_]*"')
# def readpage(link):
#    f = requests.get("https://en.wikipedia.org/wiki/"+link)
#    matches = list(x[7:-1] for x in matcher.findall(f.text))
#    return set(matches[0:5])

# Instead, we have to accept some preemptive multitasking too
# We will have to  execute readpage in separate threads.
# Infinitely many threads are evil, thus we will have 100
class PageReader:
    def __init__(self, no_workers):
        self.tp_executor = concurrent.futures.ThreadPoolExecutor(max_workers=no_workers)
        self.matcher=re.compile('"/wiki/[^:^"^#]*"')
    def readpage_blocking(self, link, ignore = set()):
        f = requests.get("https://en.wikipedia.org/wiki/"+link)        
        matches = list(x[7:-1] for x in self.matcher.findall(f.text))
        return set(matches[0:3])
    async def readpage_asyncio(self, link, ignore = set()):
        return await asyncio.get_running_loop().run_in_executor(self.tp_executor, 
                lambda : self.readpage_blocking(link, ignore))


async def main():
    pr = PageReader(100)
    level1 = await pr.readpage_asyncio('Pustý_hrad')
    all1 = level1
    print(level1)
    print("===================================")

    tasks2 = (pr.readpage_asyncio(x, all1) for x in level1)
    #concurrent execution
    level2 = set.union(*await asyncio.gather(*tasks2)) - all1
    all2 = set.union(all1, level2)
    print(level2)
    print("===================================")

    # very bad example of repeated code ...
    # hopefully, there will be no need to modify this in the futures
    # otherwise, refactoring is necessary
    tasks3 = (pr.readpage_asyncio(x, all2) for x in level2)
    level3 = set.union(*await asyncio.gather(*tasks3)) - all2
    all3 = set.union(all2, level3)
    print(level3)
    print(len(level3))
    print("===================================")

    tasks4 = (pr.readpage_asyncio(x, all3) for x in level3)
    level4 = set.union(*await asyncio.gather(*tasks4)) - all3
    all4 = set.union(all3, level4)
    print(level4)
    print(len(level4))

    print("===================================")

    tasks5 = (pr.readpage_asyncio(x, all4) for x in level4)
    level5 = set.union(*await asyncio.gather(*tasks5)) - all4
    all5 = set.union(all4, level5)
    print(level5)
    print(len(level5))

asyncio.run(main())
