# main.py
from database import engine, Base, SessionLocal
from models import Customer

def create_tables():
    # SQLAlchemy collects all table definitions in Base.metadata    
    # Read all models from Base.metadata and generates SQL CREATE TABLE statements for the database
    Base.metadata.create_all(engine)
    print("Tables created!")

def add_sample_customers():
    session = SessionLocal()
    try:
        customer1 = Customer(
            firstName="John",
            middleName="A.",
            lastName="Doe",
            eMail="john.doe@example.com",
            phone="555-1234"
        )
        customer2 = Customer(
            firstName="Jane",
            middleName=None,
            lastName="Newton",
            eMail="jane.newton@example.com",
            phone="555-5678"
        )
        # register objects within a session / no SQL sent yet
        session.add_all([customer1, customer2])        
        # 1. generates and executes SQL statements for all pending changes in the session
        # 2. commits the transaction
        session.commit()
        print("Sample customers added!")
    finally:
        session.close()

def list_customers():
    session = SessionLocal()
    try:
        # session.query(Customer) - creates a Query object in Python
        # .all() - sql is sent and the result is fetched
        customers = session.query(Customer).all()
        for c in customers:
            print(c)
    finally:
        session.close()
        
def drop_tables():
    Base.metadata.drop_all(engine)
    print("Tables dropped!")

if __name__ == "__main__":
    create_tables()
    add_sample_customers()
    list_customers()
    drop_tables()
