from datetime import date

from team import Team
from match import Match
from ranking import Ranking
from playgroup import PlayGroup, GroupInfo
from position_rank import Position, FilledPosition, Rank

start_date = date(2019, 5, 9)

#GROUP A
slovakia = FilledPosition(Team("Slovakia", 7, 7))
finland = FilledPosition(Team("Finland", 8, 8))
germany = FilledPosition(Team("Germany", 5, 7))
canada = FilledPosition(Team("Canada", 10, 9))
us = FilledPosition(Team("United States", 9, 8))
denmark = FilledPosition(Team("Denmark", 5, 5))
france = FilledPosition(Team("France", 4, 4))
uk = FilledPosition(Team("United Kingdom", 3, 3))

matchesA = (Match(finland, canada, date(2019, 5, 10)),
            Match(us, slovakia, date(2019, 5, 10)),
            Match(denmark, france, date(2019, 5, 11)),
            Match(germany, uk, date(2019, 5, 11)),
            Match(slovakia, finland, date(2019, 5, 11)),
            Match(us, france, date(2019, 5, 12)),
            Match(denmark, germany, date(2019, 5, 12)),
            Match(uk, canada, date(2019, 5, 12)),
            Match(us, finland, date(2019, 5, 13)),
            Match(slovakia, canada, date(2019, 5, 13)),
            Match(uk, denmark, date(2019, 5, 14)),
            Match(germany, france, date(2019, 5, 14)),
            Match(us, uk, date(2019, 5, 15)),
            Match(germany, slovakia, date(2019, 5, 15)),
            Match(canada, france, date(2019, 5, 16)),
            Match(finland, denmark, date(2019, 5, 16)),
            Match(france, slovakia, date(2019, 5, 17)),
            Match(finland, uk, date(2019, 5, 17)),
            Match(denmark, us, date(2019, 5, 18)),
            Match(canada, germany, date(2019, 5, 18)),
            Match(uk, slovakia, date(2019, 5, 18)),
            Match(germany, us, date(2019, 5, 19)),
            Match(france, finland, date(2019, 5, 19)),
            Match(france, uk, date(2019, 5, 20)),
            Match(canada, denmark, date(2019, 5, 20)),
            Match(finland, germany, date(2019, 5, 21)),
            Match(slovakia, denmark, date(2019, 5, 21)),
            Match(canada, us, date(2019, 5, 21)))

groupA = PlayGroup(start_date, GroupInfo("Group A", None, None, date(2019, 5, 21)), (slovakia, finland, germany, canada, us, denmark, france, uk), Ranking(), matchesA)



#GROUP B
switzerland = FilledPosition(Team("Switzerland", 6, 7))
czech = FilledPosition(Team("Czech Republic", 8, 8))
russia = FilledPosition(Team("Russia", 10, 8))
sweden = FilledPosition(Team("Sweden", 10, 9))
latvia = FilledPosition(Team("Latvia", 5, 7))
norway = FilledPosition(Team("Norway", 6, 6))
austria = FilledPosition(Team("Austria", 4, 5))
italy = FilledPosition(Team("Italy", 3, 3))

matchesB = (Match(russia, norway, date(2019, 5, 10)),
            Match(czech, sweden, date(2019, 5, 10)),
            Match(switzerland, italy, date(2019, 5, 11)),
            Match(latvia, austria, date(2019, 5, 11)),
            Match(norway, czech, date(2019, 5, 11)),
            Match(russia, austria, date(2019, 5, 12)),
            Match(italy, sweden, date(2019, 5, 12)),
            Match(latvia, switzerland, date(2019, 5, 12)),
            Match(russia, czech, date(2019, 5, 13)),
            Match(norway, sweden, date(2019, 5, 13)),
            Match(italy, latvia, date(2019, 5, 14)),
            Match(switzerland, austria, date(2019, 5, 14)),
            Match(switzerland, norway, date(2019, 5, 15)),
            Match(russia, italy, date(2019, 5, 15)),
            Match(sweden, austria, date(2019, 5, 16)),
            Match(czech, latvia, date(2019, 5, 16)),
            Match(austria, norway, date(2019, 5, 17)),
            Match(czech, italy, date(2019, 5, 17)),
            Match(latvia, russia, date(2019, 5, 18)),
            Match(italy, norway, date(2019, 5, 18)),
            Match(sweden, switzerland, date(2019, 5, 18)),
            Match(austria, czech, date(2019, 5, 19)),
            Match(switzerland, russia, date(2019, 5, 19)),
            Match(sweden, latvia, date(2019, 5, 20)),
            Match(austria, italy, date(2019, 5, 20)),
            Match(czech, switzerland, date(2019, 5, 21)),
            Match(norway, latvia, date(2019, 5, 21)),
            Match(sweden, russia, date(2019, 5, 21)))

groupB = PlayGroup(start_date, GroupInfo("Group B", None, None, date(2019, 5, 21)), (switzerland, czech, russia, sweden, latvia, norway, austria, italy), Ranking(), matchesB)


pA1, pA2, pA3, pA4 = [Position(groupA.rank(i)) for i in range(4)]
pB1, pB2, pB3, pB4 = [Position(groupB.rank(i)) for i in range(4)]

QF1 = PlayGroup(start_date, GroupInfo("Quaterfinal 1", None, None, date(2019, 5, 23)), (pA1, pB4), Ranking(), (Match(pA1, pB4, date(2019, 5, 23)),))
QF2 = PlayGroup(start_date, GroupInfo("Quaterfinal 2", None, None, date(2019, 5, 23)), (pB2, pA3), Ranking(), (Match(pB2, pA3, date(2019, 5, 23)),))
QF3 = PlayGroup(start_date, GroupInfo("Quaterfinal 3", None, None, date(2019, 5, 24)), (pB1, pA4), Ranking(), (Match(pB1, pA4, date(2019, 5, 24)),))
QF4 = PlayGroup(start_date, GroupInfo("Quaterfinal 4", None, None, date(2019, 5, 24)), (pA2, pB3), Ranking(), (Match(pA2, pB3, date(2019, 5, 24)),))

pQ1 = Position(QF1.rank(0))
pQ2 = Position(QF2.rank(0))
pQ3 = Position(QF3.rank(0))
pQ4 = Position(QF4.rank(0))

SF1 = PlayGroup(start_date, GroupInfo("Semifinal 1", None, None, date(2019, 5, 25)), (pQ1, pQ2), Ranking(), (Match(pQ1, pQ2, date(2019, 5, 25)),))
SF2 = PlayGroup(start_date, GroupInfo("Semifinal 2", None, None, date(2019, 5, 25)), (pQ3, pQ4), Ranking(), (Match(pQ3, pQ4, date(2019, 5, 25)),))

pS1 = Position(SF1.rank(0))
pS2 = Position(SF2.rank(0))
pS3 = Position(SF1.rank(1))
pS4 = Position(SF2.rank(1))

Bronze = PlayGroup(start_date, GroupInfo("Bronze Medal Game", None, None, date(2019, 5, 26)), (pS3, pS4), Ranking(), (Match(pS3, pS4, date(2019, 5, 26)),))
Final= PlayGroup(start_date, GroupInfo("Final", None, None, date(2019, 5, 26)), (pS1, pS2), Ranking(), (Match(pS1, pS2, date(2019, 5, 26)),))

def next_day():
    groupA.next_day()
    groupB.next_day()
    QF1.next_day()
    QF2.next_day()
    QF3.next_day()
    QF4.next_day()
    SF1.next_day()
    SF2.next_day()
    Bronze.next_day()
    Final.next_day()



##Zaciname##
##9. 5.
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()

def printstate(group):
    state = group.group_state(Ranking().info_strings)
    print(state.name)
    standings = {x[0]: x[1] for x in state.standings}    
    for i in range(8):
        team = group.rank(i).position.team.name
        print("%20s %d %d %d %d %d %2d:%2d %2d" % (team, standings[team]["matches"], standings[team]["wins"], standings[team]["overtime wins"], 
                                                   standings[team]["overtime losses"], standings[team]["losses"], standings[team]["goals for"], 
                                                   standings[team]["goals against"], standings[team]["points"]))
print("\n")

printstate(groupA)
printstate(groupB)
##21. 5.
print("Quaterfinals")
next_day()
next_day()
next_day()
##24. 5.
print("Semifinals")
next_day()
##25. 5.
print("Finals")
next_day()
print("And the winner is %s."% (Final.rank(0).position.team.name,))
##26. 5.




