#In this class we actually want to write a nice OO code
#This means we want to minimize the use of Python's dynamism.
#In practice, the ability to make shortcuts is useful, 
#but it is hard to manage large codebases containing many shortcuts.
#Besides this, some languages are not dynamic at all so you need to do the stuff correctly

#this is our class
class A:
    #this is static class attribute.
    #Avoid using them in this course
    b=1
    
    #This is static method
    #Avoid using them in this course
    @staticmethod
    def method1(par1):
        return par1
    
    #this is constructor, note the first self parameter
    def __init__(self, par1):
        #these are attributes
        self.attr1 = par1
        #id something is private we will indicate it with an underscore
        #this is private variable (Python does not enforce this but you are warned)
        self._attr2 = par1+1
        
    #method, note the first self argument
    def method2(self, par1):
        x = par1+self.attr1
        self.attr1 = par1
        return x
        
    #private method -> underscore
    def _myprivategetattr(self):
        return self.attr1
        
    #instead of getters and setters we use properties
    @property
    def attr2(self):
        return self._attr2
        
    @attr2.setter
    def attr2(self, value):
        self._attr2 = value
        
