from dataclasses import dataclass
from typing import List, Optional

@dataclass(frozen=True)
class GameCardType:
    plusActions: int
    plusBuys: int
    plusCards: int
    plusCoins: int
    points: int
    cost: int
    isAction: bool
    name: str
    description: str

class CardInterface:
    def evaluate(self, value: int) -> None:
        pass
    @property
    def cardType(self) -> GameCardType:
    	pass


class DiscardPile:
    _cards: List[CardInterface]    # this is not a class variable
    
    def __init__(self, cards: List[CardInterface]):
        a : int = 1
        a = a + 2
        self._cards = cards
        
    def getTopCard(self) -> Optional[CardInterface]: 
        return self._cards[-1] if self._cards else None
        
    def addCards(self, cards: List[CardInterface]) -> None:
        self._cards.extend(cards)
        
    def getSize(self) -> int:
        return len(self._cards)

