import FIFARankingStrategy
import unittest


class TestFIFARankingStrategy(unittest.TestCase):
    class StubPosition:
        pass
    class StubTeam:
        pass
    class StubMatchReport:
        pass 
    class StubFIFARanking:
        def __init__(self):
            self.teams={}
        def teamPosition(self, s):
            return self.teams[s]


    def setUp(self):      
        FIFARanking=self.StubFIFARanking()
        self.rankingStrategy=FIFARankingStrategy.FIFARankingStrategy(FIFARanking)
        self.teams={}



    def team_is_in_the_group_with_FIFA_ranking(self, team, rank):
        self.rankingStrategy.FIFARanking.teams[team]=rank
        self.teams[team]=self.StubPosition()
        self.teams[team].reports=[]
        self.teams[team].team=self.StubTeam()
        self.teams[team].team.name=team 


    def get_ranking(self):
        self.order=self.rankingStrategy.rank(list(self.teams.values()))


    def assert_rank(self, team, rank):
        self.assertEqual(self.order[team].position, rank)

    def assert_points(self, team, points):
        self.assertEqual(self.order[team].points, points)




        

   
    def test_if_no_matches_were_played_points_are_zero_and_FIFA_ranking_decides_the_ranking(self):
        self.team_is_in_the_group_with_FIFA_ranking('Germany', 1)
        self.team_is_in_the_group_with_FIFA_ranking('France', 2)
        self.get_ranking()
        self.assert_rank('Germany', 1)
        self.assert_rank('France', 2)
        self.assert_points('Germany', 0)
        self.assert_points('France', 0)


        
if __name__ == '__main__':
    unittest.main()

