﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Web.Security;

namespace AUDIOTEKA
{
    public partial class MyAlbumPage : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();

        protected void Page_Load(object sender, EventArgs e)
        {
            EditPlaceHolder.Visible = false;
            EditAlbumExistsLabel.Visible = false;
        }

        protected void ObjectDataSource_DeleteMethod(object sender, ObjectDataSourceMethodEventArgs e)
        {
            IDictionary paramsFromPage = e.InputParameters;

            paramsFromPage.Remove("AlbId");
            paramsFromPage.Add("AlbId", (int)paramsFromPage["AlbumId"]);
            paramsFromPage.Remove("AlbumId");

        }

        protected void GridView_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            PersonalAlbum AlbumToDelete = null;
            int AlbumToDeleteId = (int)MyAlbumsGridView.DataKeys[e.RowIndex].Value;

            try
            {
                AlbumToDelete = (from alb in _db.PersonalAlbums
                                 where alb.AlbumId == AlbumToDeleteId
                                 select alb).First();
            }
            catch (Exception)
            {
            }

            if (AlbumToDelete != null)
            {
                _db.PersonalAlbums.DeleteOnSubmit(AlbumToDelete);
                _db.SubmitChanges();
            }
        }
        protected void GridView_RowEdit(object sender, GridViewSelectEventArgs e)
        {
            EditHiddenField.Value = "";

            int AlbumId = (int)MyAlbumsGridView.DataKeys[e.NewSelectedIndex].Value;

            MembershipUser myUser = Membership.GetUser();
            Guid UserID = (Guid)myUser.ProviderUserKey;

            PersonalAlbum PAlbumToEdit = (from pa in _db.PersonalAlbums
                                          where pa.AlbumId == AlbumId & pa.UserId == UserID
                                          select pa).First();
            string AlbumName = (from a in _db.Albums
                                where a.AlbumId == AlbumId
                                select a.AlbumName).First();

            if (PAlbumToEdit != null)
            {
                EditPlaceHolder.Visible = true;
                EditNadpis.InnerText = "Úprava informácií k albumu: " + AlbumName;
                EditHiddenField.Value = AlbumId.ToString();
                EditQualityTextBox.Text = PAlbumToEdit.Quality;
                EditStorageTextBox.Text = PAlbumToEdit.StorageMedium;
                EditDropDownList.SelectedIndex = Convert.ToInt32(PAlbumToEdit.Rating) - 1;
            }
        }
        protected void EditButton_Click(object sender, EventArgs e)
        {

            int albumcount = (from pa in _db.PersonalAlbums
                              where pa.AlbumId.ToString() == EditHiddenField.Value.ToString()
                              select pa).Count();

            if (albumcount == 1)
            {
                PersonalAlbum AlbumToEdit = (from pa in _db.PersonalAlbums
                                             where pa.AlbumId.ToString() == EditHiddenField.Value.ToString()
                                             select pa).First();

                if (AlbumToEdit != null)
                {
                    AlbumToEdit.Quality = EditQualityTextBox.Text;
                    AlbumToEdit.StorageMedium = EditStorageTextBox.Text;
                    AlbumToEdit.Rating = EditDropDownList.SelectedValue;

                    _db.SubmitChanges();

                    EditPlaceHolder.Visible = false;
                    MyAlbumsDataSource.DataBind();
                    MyAlbumsGridView.DataBind();

                }

                EditPlaceHolder.Visible = false;
            }
            else
            {
                EditAlbumExistsLabel.Visible = true;
            }

        }
    }
}
