<?php 
if (File_Exists('head.php')) {
  include('head.php');
}
title('Odviaž sa - špecifikácia projektu');

if (File_Exists('header.php')) {
  include('header.php');
}
?>

<div id="content">
      <div id="leftright">
        <h2>Špecifikácia ročníkového projektu</h2>
                  
                  <h3>1.	Definícia projektu</h3>

                  <p>Odviaž sa je internetová aplikácia, ktorá je určená najmä mladým ľudom, aby mohli spolu komunikovať a navzájom sa spoznávať. 
                  Každý má možnosť poznať nových ľudí presne podľa svojich predstáv. Portál združuje návštevníkov s podobnými záľubami, túžbami 
                  či vlastnosťami, ktoré by sa inak len ťažko hľadali. Užívatelia sa taktiež môžu dozvedieť aký názor majú na nich ostatní, či už sa 
                  jedná o vzhľad, vnútorné vlastnosti alebo rôzne schopnosti. Aplikácia nie je klasický chat, ale skôr pomocník a sprievodca, ktorý 
                  užívateľovi ukáže aká osobnosť v skutočnosti je.</p>

                  <h3>2.	Funkčná špecifikácia</h3>

                  <p>Projekt obsahuje niekoľko cieľových skupín používateľov s rozličnými možnosťami a sprístupnenými funkciami. 
                  Každý návštevník má k dispozícii klasické možnosti, ako sú prístup na hlavnú stránku, prístup k profilom jednotlivých 
                  užívateľov, možnosť registrácie, prípadne jej zrušenie a ďalšie iné, uvedené v ďalších bodoch funkčnej špecifikácie.</p>
                  
                  <h3>2.1	  Cieľové skupiny</h3>
                  
                  <p>V aplikácii rozlišujeme niekoľko rôznych typov používateľov:</p>
                  <ul>
                    <li>                  
                      Nezaregistrovaní návštevníci:<br />
                      Majú k dispozícii len zopár funkcií, ako prezeranie webstránky vrátane užívateľských profilov. 
                      Nemajú možnosť posielať správy, prispievať do diskusií ani hodnotiť, resp. hlasovať za rôznych užívateľov. 
                      Môžu sa však bez obmedzení zaregistrovať a tým rozšíriť rozsah svojich možností v aplikácii.
                    </li>

                    <li>
                      Registrovaní užívatelia
                      Týmto typom používateľa sa stane návštevník po úspešnej registrácii. Môže spravovať vlastný profil a uverejniť fotografiu svojho vzhľadu. 
                      K dispozícii má taktiež posielanie súkromných správ, resp. chatovanie s iným užívateľom. Povolené má tiež posielanie komentárov a hodnotenie 
                      fotografií, vlastností či charakteru ďalších užívateľov. Registrovaný užívateľ môže vlastniť aj virtuálne kredity, ktoré sa dajú využiť na 
                      rôzne vylepšenia. Užívatelia môžu získať ďalšie výhody po tom, čo bude vytvorený nejaký nový modul určený práve im.
                    </li>
                    <li> 
                      Administrátori                    
                      Starajú sa o bezproblémový chod portálu. Administrátorov rozlišujeme na tzv. hlavného administrátora a ďalších administrátorov. 
                      Hlavný administrátor je len jeden a má prístup k celej správe administrácii aplikácie. Môže vytvárať, upravovať a mazať údaje zo 
                      všetkých funkcií, ktoré má registrovaný i neregistrovaný užívateľ. Taktiež môže vytvárať ďalších adminov, ktorí majú len tie administrátorské práva, 
                      ktoré im hlavný admin povolí.
                    </li>                  
                  </ul>
                 
                  <h3>2.2	  Popis primárnych funkcií</h3>
                  
                  <p>Táto časť obsahuje podrobnejší popis funkcií, ktoré majú k dispozícii cieľové skupiny projektu.</p>

                  
                  <h3>2.2.1	Registrácia, prihlásenie a zrušenie užívateľa</h3>
                  
                  <p>Návštevník sa zaregistruje do systému po vyplnení registračného formulára. Ten obsahuje povinnú a nepovinnú časť. 
                  Nepovinná časť nemusí byť vyplnená, aby bola registrácia úspešne dokončená. Medzi povinné položky formulára patrí: 
                  Nick (prezývka), e-mail, heslo, overenie hesla, overovací kód a súhlas s pravidlami portálu. Nepovinná časť sa skladá z položiek, 
                  ktoré budú (v prípade vyplnenia) uverejnené v profile. Počas registrácie sa dajú preskočiť a v prípade potreby vyplniť dodatočne. 
                  Nepovinnú časť registrácie tvoria skupiny položiek, ako sú popis užívateľa, osobné informácie, osobná fotografia, postava, záľuby, 
                  povaha, rôzne názory a dodatočné údaje.</p>
                  
                  <p>Po úspešnej registrácii sa môže užívateľ prihlásiť po zadaní prezývky a hesla. Po prihlásení sa dajú meniť 
                  všetky údaje vyplnené počas registrácie okrem nicku. V prípade potreby užívateľ môže svoj účet zrušiť.</p>
                  
                  <h3>2.2.2	Užívateľský profil</h3> 
                  
                  <p>Obsahuje všetky vyplnené nepovinné súčasti registrácie. V profile sa nachádzajú aj názory, resp. komentáre 
                  týkajúce sa daného užívateľa.. V prípade, že užívateľ uverejnil aj svoju fotografiu, tak ju môžu ostatní zaregistrovaní 
                  hodnotiť. Hodnotiť sa dá taktiež aj charakter užívateľa.</p>
                  
                  <h3>2.2.3	Komunikácia (chat) medzi užívateľmi</h3>

                  
                  <p>Každý registrovaný užívateľ má k dispozícii funkciu na komunikáciu s iným užívateľom. Táto výmena informácii je súkromná a žiadny 
                  iný užívateľ k nej nemá prístup. Každý rozhovor sa ukladá do archívu, ktorý si môže užívateľ podľa potreby premazať.</p> 
                  
                  <h3>2.2.4	Kreditný systém</h3>
                  
                  <p>Každý kto ohodnotí nejakú fotografiu dostane určitý počet kreditov a naopak, ten ktorého fotografia je hodnotená kredity stráca. 
                  Finálny počet získaných, resp. stratench kreditov sa presne určí až pri finálnom testovaní aplikácie.</p>
                  
                  
                  <h3>2.2.5	Vyhľadávanie užívateľov</h3>
                  
                  <p>Vyhľadávať užívateľov bude možné podľa viacerých kritérií, ako sú pohlavie, vek, povahové vlastnosti, obľúbené športy, koníčky a podobne.</p>
                  
                  <h3>2.2.6	Administrácia</h3>

                  
                  <p>Prístup k jednotlivým častiam administrácie systému udeľuje len hlavný administrátor, ktorý má prístup ku všetkým funkciám portálu.</p>
                  
                  <h3>2.3	  Prídavné moduly</h3>
                  
                  <p>Okrem primárnych funkcií aplikácia môže obsahovať aj iné, neskôr doprogramované moduly, ako sú napríklad ankety, diskusné 
                  fóra, blogovací systém, fotogalérie a podobne.</p>
                  
                  <h3>3.	Vstupy a výstupy</h3>
                  
                  <p>Vstupmi sú dáta posielané užívateľmi vo forme textu a obrázkov. Vstupné údaje sú vkladané pri registrácii, komunikácii, 
                  no aj pri hodnoteniach. Výstupom sú zobrazenia profilov, obrázkov a komentárov, archív komunikácie medzi užívateľmi a zobrazenia jednotlivých hodnotení.</p>
                  
                  <h3>4.	Návrh riešenia</h3>

                  
                  <p>Uvedenie požívaných technológií, predpoklad krízových situácií v projekte a analyzovanie postupu riešenia projektu.</p>
                  
                  <h3>4.1	  Používané technológie</h3>
                  
                  <p>Aplikácia sa bude programovať v PHP a JavaScripte. Databázy budú realizované jazykom SQL v rozhraní MySQL. Vzhľad web stránky 
                  bude tvorený pomocou XHTML a CSS.</p>
                  
                  <h3>4.2	  Krízové body</h3>
                  
                  <p>V prípade veľkej aktivity užívateľov môže nastať preťaženie servera. Môže nastať aj zahltenie diskových kapacít z dôvodu enormného uploadovania obrázkov.                   
                  Na bezpečnosť aplikácie bude kladený veľký dôraz, no nikdy nie je možné zaručiť jej 100% záruku. Informácie sú veľmi dôležité a preto 
                  nemôže nastať k ich získaniu a prípadnému zneužitiu. Bezpečnosť sa bude sústrediť najmä na zabránenie najčastejším typom útokov ako sú 
                  SQL Injection, Cross Site Scripting, Session Stealing a Session Hijacking.</p>
                  
                  <h3>4.3	  Analýza a postup riešenia projektu</h3>

                  
                  <p>Riešenie projektu pozostáva z častí:</p>
                  
                  <ul>
                    <li>Registrácia, prihlásenie a nastavenie užívateľa</li>
                    <li>Zobrazovanie profilu, komentáre, kreditný systém a funkcie hodnotení užívateľa</li>
                    <li>Vyhľadávanie</li>
                    <li>Komunikácia medzi jednotlivými užívateľmi</li>
                    <li>Administrácia</li>

                    <li>Prídavné moduly</li>
                  </ul>
                  
                  
                  <h3>5.	Časový plán</h3>
                  
                  <p>Rozdelenie funkčnej špecifikácie v čase.</p>
                  
                  <h3>5.1	  Prvá etapa</h3>
                  
                  <p>Základný vzhľad web rozhrania. Registrácia, prihlásenie a možnosť zmeny užívateľských nastavení</p>

                  
                  <h3>5.2	  Druhá etapa</h3>
                  
                  <p>Správna funkčnosť profilu, správne zobrazenie foto portrétu. </p>
                  
                  <h3>5.3	  Tretia etapa</h3>
                  
                  <p>Implementácia kreditného systému a funkcií na hodnotenia užívateľa. Vyhľadávanie užívateľov podľa rôznych kritérií.</p>
                  
                  <h3>5.4	  Štvrtá etapa</h3>
                  
                  <p>Vytvorenie komunikačného modulu pre užívateľov</p>

                  
                  <h3>5.5	  Piata etapa</h3>
                  
                  <p>Zhotovenie administrácie pre projekt</p>
                  
                  <h3>5.6	   Šiesta etapa</h3>
                  
                  <p>Testovanie aplikácie, odstraňovanie prípadných chýb vo vzhľade a kóde. Prípadné vytvorenie prídavných modulov.</p>


              


      
      </div>
      
    
    </div>
    
    <?php 
if (File_Exists('footer.php')) {
  include('footer.php');
}
?>    