<?php

/*
* Posledná úprava dňa: 31.4.2009
* Vytvoril Ján Januška
*/

/*
* UPDATES
* - Ak je len jedna strana strankovania, tak sa nezobrazi html vystup strankovania
* - Opravena chyba, ked v url nesli predavat ine premenne
*/

/* 
* PREMENNE 
* $pocet_vysledkov = celkovy pocet riadkov z DB napr.
* $pocet_na_stranu = kolko vyskedkov (riadkov z DB) bude na strane
* $medzicisla = pocet zobrazovanych odkazov na stranky pred a za sucasnou stranou ( 5 6 7 8 9 napr...)   
* $nazov_get = nazov premennej aktualnej strany predavany v parametri get
* $strana = aktualna strana
* $vystup = xhtml vystup strankovania
* 
* FCIE
* Konstruktor vytvori vsetky potrebne vystupy
* $strankovanie->offset = od ktoreho riadku berieme udaje, resp. to je vystup pre OFFSET v DB
* $strankovanie->vystup = xhtml vystup strankovania
* $strankovanie->pocet_na_stranu = kolko zaznamov je na jednej strane, resp. LIMIT pre DB. Je to vlastne zbytocna fcia urcena pre lamy
*/

class CStrankovanie {
   private
      $pocet_vysledkov,
      $pocet_na_stranu,
      $medzicisla,
      $nazov_get,
      $strana,
      $vystup;
      
  function __construct($pocet_vysledkov, $pocet_na_stranu = 5, $medzicisla = 2 , $nazov_get = 'strana'){
     $this->pocet_vysledkov = $pocet_vysledkov;
     $this->pocet_na_stranu = $pocet_na_stranu;
     $this->medzicisla = $medzicisla + 1;
     $this->nazov_get = $nazov_get;
     
     // zistovanie poctu stran. Ak nam vyjde pocet stran a este zvysok, tak pocet stran zvacsime o jedno
     if (($this->pocet_vysledkov % $this->pocet_na_stranu) == 0) 
        $pocet_stran = intval($this->pocet_vysledkov / $this->pocet_na_stranu);
     else
        $pocet_stran = intval($this->pocet_vysledkov / $this->pocet_na_stranu)+1; 
        

       //kontrolujeme, ci bola v url zadana konkretna vysledkova strana
    if (isset($_GET[$this->nazov_get]) and intval($_GET[$this->nazov_get] > 0)){
       $this->strana = intval($_GET[$this->nazov_get]);
    }
    else $this->strana = 1;   
	
   
   //vygenerovanie premennych v url adrese. Vraciame cele aktualne pole $_GET okrem pnazov_get, to nahradime potom.
   //3 hodiny som rozmyslal, ci to nepojde elegantnejsie urobit, ale asi nie.
   $gety = '?';
   foreach ($_GET as $nazov => $hodnota) {                         
     if ($nazov != $this->nazov_get)
 	 	$gety .= $nazov . '=' . $hodnota . '&'; 
  }
    //vypis... je vytvoreny len vtedy ,ak je viac stran ako jedna
    if ($pocet_stran > 1){
		
		//zaciatok a krok spat
		$spat = 'začiatok | &lt;&lt;';
		if ($this->strana > 1){
		   $spat = '<a href="' . $_SERVER['PHP_SELF'] . $gety . $this->nazov_get . '=1' . '">začiatok</a>' . ' | ';
		   $spat .= '<a href="'. $_SERVER['PHP_SELF'] . $gety . $this->nazov_get . '=' . ($this->strana-1) . '">&lt;&lt;</a> ';
		}
		
		//vystup zvacsime o zaciatok
		$this->vystup .= $spat;
		
		//prechadzame jednotlive strany a vypisujeme ich
		for ($i = 1; $i <= $pocet_stran ; $i++){
		   //pocet cisiel pred a za aktualnou stranou
		   if ($i >($this->strana - $this->medzicisla) && $i < $this->strana){
			  $this->vystup .='<a href="' . $_SERVER['PHP_SELF'] . $gety . $this->nazov_get . '=' .$i . '">' . $i . '</a> ' ;
		   }
		   if ($i == $this->strana){
			  $this->vystup .= '<strong>' .$i . '</strong>';
		   }
		   if ($i > $this->strana && $i < ($this->strana + $this->medzicisla)){
			  $this->vystup .=' <a href="' . $_SERVER['PHP_SELF'] . $gety . $this->nazov_get . '=' . $i . '">' . $i . '</a> ' ;
		   }
		
		}
		
		//koniec a krok dalej
		$dalej = ' &gt;&gt; | koniec';
		if ($this->strana < $pocet_stran){
		   $dalej = ' <a href="'. $_SERVER['PHP_SELF'] . $gety . $this->nazov_get . '=' . ($this->strana+1) . '"> &gt;&gt;</a>';
		   $dalej .= ' | <a href="' . $_SERVER['PHP_SELF'] . $gety . $this->nazov_get . '=' . $pocet_stran . '">koniec</a>';
		}
		
		//vystup zvacsime o koniec
		$this->vystup .= $dalej;
	}
	else $this->vystup .= ''; //jedna strana, ziadny vystup
  }
  
  public function __get($str) {
     switch($str) {
        case 'offset': //odkial strankujeme, resp. OFFSET v DB
           return $this->pocet_na_stranu * ($this->strana -1);
           break;
        case 'vystup':
           return $this->vystup;
           break;
        case 'pocet_na_stranu':
           return $this->pocet_na_stranu;
           break;
    }
  }  
}

// nahradenie vulgarizmov danym retazcom
class CCenzura {
 // treba dokodit tuto nezbytnost pre drze a vynervovane decka, ci ine individua
}
?>