<?php

/**
 * @abstract function sets default parameters to connect to database
 * @return array array of default values of connection to database
 */
 function getDBDefaults(){

	 //Server on which we providing our database
	 $db['host'] = "localhost";

	 //Port on which we are connecting
	 $db['port'] = "5432";	 
	 
	 //Username with which we log-in to the database
	 $db['user'] = "postgres";
	 
	 //Password with which we log-in to the database
	 $db['pass'] = "";

	 //Name of the database
	 $db['name'] = "lamsfet";
	 
	 return $db;
 }
 

/**
 * @abstract function sets default parameters to create page
 * @return array array of default values of page
 */
 function getPageDefaults(){
 	
 	//Default title of page
 	$page['title'] = "LaMSfET";
 	
 	//Included method. It can be require, include, require_once, include_once
 	$page['include_method'] = "require_once";
 	
 	//Path of directory of all included files
 	$page['include_path'] = "include";
 	
 	//Path of CSS files
 	$page['styles_path'] = "css";

 	//Login page URL
 	$page['login_page'] = "index.php?page=login";
 	
 	//Files, which have to be included on every loading of page
 	//TODO: Not all files have to be included on every page - solution: page types
 	$page['include_files'] = array( "functions.php","pgTable.class.php","tables/tblBoxes.class.php","tables/tblPages.class.php",
									"smarty/libs/Smarty.class.php","box.class.php",
									"url.class.php","listing.class.php","listingRenderer.class.php",
									"listingTableRenderer.class.php","listingStylizer.class.php","listingDataFormatting.class.php",
									"user.class.php","tables/authorizationTable.class.php");

 	//solid boxes
 	$page['solid_boxes'] = array("navigation"=>10,"open_set"=>28,"search_form"=>31);
 	
 	//Meta information
 	$page['meta']['description'] = "";
 	$page['meta']['charset'] = "utf-8";
 	$page['meta']['keywords'] = array();
 	$page['meta']['author'] = "Peter Jurco";
 	$page['meta']['copyright'] = "&copy; 2009";
 	$page['meta']['expires'] = "0";
 	$page['meta']['robots'] = "noindex,nofollow,nocache";
 	$page['meta']['language'] = "sk";

	$page['public'] = false;
 	
 	return $page;	
 }
 
 function systemName(){
 	return "LaMSfET";
 }
 
 /**
  * @abstract autoload function. Used to loading boxes and table classes. Can be later extended.
  */
 function __autoload($class_name){
	//boxy hladame v priecinku daneho modulu
	if (file_exists(CLASS_PATH."/".$class_name.".class.php")) 
		require_once CLASS_PATH."/".$class_name.".class.php";
	//triedy tauliek hladame v priecinku include/tables
	elseif (file_exists("include/tables/".$class_name.".class.php"))
		require_once "include/tables/".$class_name.".class.php";
	//pevne boxy su v module home		
	elseif (file_exists("modules/home/".$class_name.".class.php"))
		require_once "modules/home/".$class_name.".class.php";	
  	//automatic maker table classes
  	elseif(substr($class_name,-5)=="Table"){
    	$table_name = "";
    	for($i=0; $i<(strlen($class_name)-5); $i++)
	      if($class_name[$i]>="A" && $class_name[$i]<="Z")
	        $table_name .= "_".strtolower($class_name[$i]);
	      else  
	        $table_name .= $class_name[$i];
    	$content = '<?php
class '.$class_name.' extends pgTable{
  protected $table_name = "'.$table_name.'";
} 
?>';
	    $filename = "include/tables/";
	    if(!file_exists($filename))    
	      $filename = "../".$filename;
	    $fp = fopen($filename.$class_name.'.class.php', 'w');
	
	    fwrite($fp, $content);
	    fclose($fp);    
	    require_once $filename.$class_name.".class.php";
  	}
	else{
		print "POZOR! Chyba nam subor obsahujuci triedu ".$class_name."<br/>Nemozem pokracovat dalej... Riesenie: Najdite subor s danou triedou (zacal by som hladat v priecinku include) a vlozte ho do prislusneho pola v subore config.php";
		exit;
	}
				
 }

?>