--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: authorization; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE "authorization" (
    id integer NOT NULL,
    user_id integer NOT NULL,
    login character varying(255) NOT NULL,
    password character varying(32) NOT NULL,
    count integer NOT NULL,
    last_access timestamp without time zone NOT NULL
);


ALTER TABLE public."authorization" OWNER TO postgres;

--
-- Name: authorization_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE authorization_groups (
    id integer NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE public.authorization_groups OWNER TO postgres;

--
-- Name: boxes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE boxes (
    id integer NOT NULL,
    page_id integer NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    "position" character varying(255)
);


ALTER TABLE public.boxes OWNER TO postgres;

--
-- Name: command_line_vars; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE command_line_vars (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    type character varying(255) NOT NULL
);


ALTER TABLE public.command_line_vars OWNER TO postgres;

--
-- Name: courses; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE courses (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    short_name character varying(255)
);


ALTER TABLE public.courses OWNER TO postgres;

--
-- Name: courses_set_types; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE courses_set_types (
    id integer NOT NULL,
    course_term_id integer NOT NULL,
    set_type_id integer NOT NULL,
    is_public boolean NOT NULL,
    excercise_offset integer,
    excercise_delay integer
);


ALTER TABLE public.courses_set_types OWNER TO postgres;

--
-- Name: TABLE courses_set_types; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE courses_set_types IS 'typy sad, ktore sa pouzivaju na danom predmete a nastavenia pre nich';


--
-- Name: COLUMN courses_set_types.excercise_offset; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN courses_set_types.excercise_offset IS 'kedy sa zacne zostava zverejnovat vzhladom k casu cvicenia (v min.)
Ak je nastavene na null, zostava sa zverejni podla casu zadaneho pri jej editacii';


--
-- Name: COLUMN courses_set_types.excercise_delay; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN courses_set_types.excercise_delay IS 'bere sa do uvahy iba ak je nastavene excercise_offset na nenullovu hodnotu a znamena cas (v min.) po aku dobu bude zadanie zverejnene';


--
-- Name: courses_terms; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE courses_terms (
    id integer NOT NULL,
    course_id integer NOT NULL,
    year character varying(10) NOT NULL,
    term character(1) NOT NULL,
    is_active boolean DEFAULT true NOT NULL
);


ALTER TABLE public.courses_terms OWNER TO postgres;

--
-- Name: COLUMN courses_terms.is_active; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN courses_terms.is_active IS 'ci je semester aktivny... V systeme ho stale evidujeme, ale nove zostavy k nemu uz pridavat nemozeme';


--
-- Name: dictionary; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE dictionary (
    id integer NOT NULL,
    original text NOT NULL,
    translated text NOT NULL
);


ALTER TABLE public.dictionary OWNER TO postgres;

--
-- Name: evaluation; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE evaluation (
    id integer NOT NULL,
    student_id integer NOT NULL,
    item_id integer NOT NULL,
    points real,
    comment text,
    is_published boolean DEFAULT false NOT NULL
);


ALTER TABLE public.evaluation OWNER TO postgres;

--
-- Name: TABLE evaluation; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE evaluation IS 'hodnotenie studentov';


--
-- Name: evaluation_items; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE evaluation_items (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    set_id integer,
    course_term_id integer
);


ALTER TABLE public.evaluation_items OWNER TO postgres;

--
-- Name: TABLE evaluation_items; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE evaluation_items IS 'polozky, za ktore moze dostat student body. Mozu to byt zostavy, ale aj ine zadane polozky.';


--
-- Name: excercise_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE excercise_groups (
    id integer NOT NULL,
    day integer NOT NULL,
    "time" time without time zone NOT NULL,
    teacher character varying(255),
    course_term_id integer NOT NULL,
    place character varying(255),
    capacity integer NOT NULL
);


ALTER TABLE public.excercise_groups OWNER TO postgres;

--
-- Name: TABLE excercise_groups; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE excercise_groups IS 'skupiny studentov na cvicenia';


--
-- Name: labels; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE labels (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    parent_id integer NOT NULL
);


ALTER TABLE public.labels OWNER TO postgres;

--
-- Name: pages; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pages (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    description text,
    template character varying(255) NOT NULL,
    module character varying(255) NOT NULL,
    is_public boolean DEFAULT false NOT NULL
);


ALTER TABLE public.pages OWNER TO postgres;

--
-- Name: pages_access; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pages_access (
    id integer NOT NULL,
    page_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.pages_access OWNER TO postgres;

--
-- Name: pages_attached_files; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE pages_attached_files (
    id integer NOT NULL,
    file_name character varying(512) NOT NULL,
    file_type character varying(255) NOT NULL,
    page_id integer NOT NULL
);


ALTER TABLE public.pages_attached_files OWNER TO postgres;

--
-- Name: set_types; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE set_types (
    id integer NOT NULL,
    name character varying(255) NOT NULL
);


ALTER TABLE public.set_types OWNER TO postgres;

--
-- Name: sets; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sets (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    date_from timestamp without time zone,
    date_to timestamp without time zone,
    course_term_id integer NOT NULL,
    set_type_id integer NOT NULL,
    week date
);


ALTER TABLE public.sets OWNER TO postgres;

--
-- Name: settings; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE settings (
    id integer NOT NULL,
    property character varying(255) NOT NULL,
    value text NOT NULL,
    user_id integer DEFAULT 0 NOT NULL,
    description text
);


ALTER TABLE public.settings OWNER TO postgres;

--
-- Name: solutions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE solutions (
    id integer NOT NULL,
    task_id integer NOT NULL,
    solution text NOT NULL,
    note text
);


ALTER TABLE public.solutions OWNER TO postgres;

--
-- Name: TABLE solutions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE solutions IS 'tabulka spravnych rieseni k uloham (riesenia zadane administratorom)';


--
-- Name: students; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE students (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    surname character varying(255) NOT NULL,
    auth_id integer,
    email character varying(255)
);


ALTER TABLE public.students OWNER TO postgres;

--
-- Name: students_in_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE students_in_groups (
    id integer NOT NULL,
    group_id integer NOT NULL,
    student_id integer NOT NULL,
    confirmed boolean DEFAULT false NOT NULL
);


ALTER TABLE public.students_in_groups OWNER TO postgres;

--
-- Name: unassigned_students; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE unassigned_students (
    id integer NOT NULL,
    student_id integer NOT NULL,
    course_term_id integer NOT NULL,
    confirmed boolean DEFAULT false NOT NULL
);


ALTER TABLE public.unassigned_students OWNER TO postgres;

--
-- Name: TABLE unassigned_students; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE unassigned_students IS 'tabulka studentov, ktori sa prihlasili na predmet, ale este neboli zadeleni do ziadnej skupiny';


--
-- Name: students_courses; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW students_courses AS
    SELECT sig.student_id, eg.course_term_id, sig.confirmed, ct.is_active, ct.course_id FROM (((students_in_groups sig JOIN students s ON ((s.id = sig.student_id))) JOIN excercise_groups eg ON ((eg.id = sig.group_id))) JOIN courses_terms ct ON ((ct.id = eg.course_term_id))) UNION SELECT us.student_id, us.course_term_id, us.confirmed, ct.is_active, ct.course_id FROM (unassigned_students us JOIN courses_terms ct ON ((ct.id = us.course_term_id)));


ALTER TABLE public.students_courses OWNER TO postgres;

--
-- Name: VIEW students_courses; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON VIEW students_courses IS 'predmety, ku ktorym je student priradeny';


--
-- Name: students_groups_view; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW students_groups_view AS
    SELECT s.id AS student_id, s.name AS student_name, s.surname AS student_surname, s.email AS student_email, sig.confirmed, sig.id AS sig_id, eg.id, eg.day, eg."time", eg.teacher, eg.place, eg.capacity, ct.year, ct.term, ct.id AS course_term_id, c.name AS course_name, c.short_name AS course_short_name FROM ((((excercise_groups eg LEFT JOIN students_in_groups sig ON ((sig.group_id = eg.id))) LEFT JOIN students s ON ((sig.student_id = s.id))) LEFT JOIN courses_terms ct ON ((eg.course_term_id = ct.id))) LEFT JOIN courses c ON ((ct.course_id = c.id))) WHERE ct.is_active;


ALTER TABLE public.students_groups_view OWNER TO postgres;

--
-- Name: students_solutions; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE students_solutions (
    id integer NOT NULL,
    student_id integer NOT NULL,
    set_id integer NOT NULL,
    submit_time timestamp without time zone NOT NULL,
    file_name character varying(255) NOT NULL,
    ip_address character varying(50) NOT NULL
);


ALTER TABLE public.students_solutions OWNER TO postgres;

--
-- Name: TABLE students_solutions; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE students_solutions IS 'tabulka rieseni odoslanych studentami';


--
-- Name: tasks; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tasks (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    text text NOT NULL,
    active boolean DEFAULT true NOT NULL
);


ALTER TABLE public.tasks OWNER TO postgres;

--
-- Name: tasks_in_sets; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tasks_in_sets (
    id integer NOT NULL,
    set_id integer NOT NULL,
    task_id integer NOT NULL,
    "order" integer,
    points real,
    add_text text,
    filename character varying(255),
    directory character varying(255)
);


ALTER TABLE public.tasks_in_sets OWNER TO postgres;

--
-- Name: tasks_labels; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tasks_labels (
    id integer NOT NULL,
    task_id integer NOT NULL,
    label_id integer NOT NULL
);


ALTER TABLE public.tasks_labels OWNER TO postgres;

--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    surname character varying(255) NOT NULL,
    email character varying(255) NOT NULL
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: users_in_groups; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE users_in_groups (
    id integer NOT NULL,
    authorization_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.users_in_groups OWNER TO postgres;

--
-- Name: has_label(integer, integer, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION has_label(integer, integer, text) RETURNS boolean
    AS $_$
DECLARE
    p_task ALIAS FOR $1;
    p_label ALIAS FOR $2;
    p_mode ALIAS FOR $3;
BEGIN
	IF p_mode = 'only' THEN
	PERFORM * FROM tasks_labels WHERE task_id=p_task AND label_id=p_label;
	END IF;
	IF p_mode = 'children' THEN
	PERFORM * FROM tasks_labels WHERE task_id=p_task AND (label_id=p_label OR is_label_descendant(label_id,p_label));
	END IF;

	IF NOT FOUND THEN
		RETURN FALSE;
	ELSE
		RETURN TRUE;
	END IF;
	
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.has_label(integer, integer, text) OWNER TO postgres;

--
-- Name: is_label_descendant(integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION is_label_descendant(integer, integer) RETURNS boolean
    AS $_$
DECLARE
    p_son ALIAS FOR $1;
    p_label ALIAS FOR $2;
    label RECORD;
BEGIN
	FOR label IN SELECT * FROM labels WHERE parent_id=p_label LOOP 
		IF label.id = p_son THEN
		  RETURN TRUE;
		ELSE
		  IF is_label_descendant(p_son,label.id) THEN
		    RETURN TRUE;
		  END IF;  
		END IF;  
	END LOOP;
	RETURN FALSE;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.is_label_descendant(integer, integer) OWNER TO postgres;

--
-- Name: task_down(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION task_down(integer) RETURNS boolean
    AS $_$
DECLARE
    p_task ALIAS FOR $1;
    taskup record;
    taskdown record;
BEGIN
	SELECT INTO taskdown * FROM tasks_in_sets WHERE id=p_task;
	SELECT INTO taskup * FROM tasks_in_sets WHERE set_id=taskdown.set_id AND "order"=taskdown."order"+1;
	IF FOUND THEN
		UPDATE tasks_in_sets SET "order"="order"-1 WHERE id=taskup.id;
		UPDATE tasks_in_sets SET "order"="order"+1 WHERE id=taskdown.id;
		RETURN true;
	ELSE
		RETURN false;
	END IF;

	
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.task_down(integer) OWNER TO postgres;

--
-- Name: task_last_use_on_course(integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION task_last_use_on_course(integer, integer) RETURNS timestamp without time zone
    AS $_$
DECLARE
    p_task_id ALIAS FOR $1;
    p_course_id ALIAS FOR $2;
    date_rec record;
BEGIN
	SELECT INTO date_rec max(date_from) AS last_use FROM  tasks_in_sets AS ts
	INNER JOIN sets ON sets.id=ts.set_id
	INNER JOIN courses_terms AS ct ON sets.course_term_id=ct.id
	INNER JOIN courses ON ct.course_id=courses.id
	WHERE ts.task_id = p_task_id AND courses.id = p_course_id;

	RETURN date_rec.last_use;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.task_last_use_on_course(integer, integer) OWNER TO postgres;

--
-- Name: task_up(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION task_up(integer) RETURNS boolean
    AS $_$
DECLARE
    p_task ALIAS FOR $1;
    taskup record;
    taskdown record;
BEGIN
	SELECT INTO taskup * FROM tasks_in_sets WHERE id=p_task;
	IF taskup.order > 1 THEN
		SELECT INTO taskdown * FROM tasks_in_sets WHERE set_id=taskup.set_id AND "order"=taskup."order"-1;
		UPDATE tasks_in_sets SET "order"="order"-1 WHERE id=taskup.id;
		UPDATE tasks_in_sets SET "order"="order"+1 WHERE id=taskdown.id;
		RETURN true;
	ELSE
		RETURN false;
	END IF;

	
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.task_up(integer) OWNER TO postgres;

--
-- Name: authorization_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE authorization_groups_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.authorization_groups_id_seq OWNER TO postgres;

--
-- Name: authorization_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE authorization_groups_id_seq OWNED BY authorization_groups.id;


--
-- Name: authorization_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('authorization_groups_id_seq', 2, true);


--
-- Name: authorization_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE authorization_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.authorization_id_seq OWNER TO postgres;

--
-- Name: authorization_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE authorization_id_seq OWNED BY "authorization".id;


--
-- Name: authorization_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('authorization_id_seq', 2, true);


--
-- Name: boxes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE boxes_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.boxes_id_seq OWNER TO postgres;

--
-- Name: boxes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE boxes_id_seq OWNED BY boxes.id;


--
-- Name: boxes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('boxes_id_seq', 43, true);


--
-- Name: command_line_vars_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE command_line_vars_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.command_line_vars_id_seq OWNER TO postgres;

--
-- Name: command_line_vars_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE command_line_vars_id_seq OWNED BY command_line_vars.id;


--
-- Name: command_line_vars_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('command_line_vars_id_seq', 2, true);


--
-- Name: courses_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE courses_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.courses_id_seq OWNER TO postgres;

--
-- Name: courses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE courses_id_seq OWNED BY courses.id;


--
-- Name: courses_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('courses_id_seq', 3, true);


--
-- Name: courses_set_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE courses_set_types_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.courses_set_types_id_seq OWNER TO postgres;

--
-- Name: courses_set_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE courses_set_types_id_seq OWNED BY courses_set_types.id;


--
-- Name: courses_set_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('courses_set_types_id_seq', 24, true);


--
-- Name: courses_terms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE courses_terms_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.courses_terms_id_seq OWNER TO postgres;

--
-- Name: courses_terms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE courses_terms_id_seq OWNED BY courses_terms.id;


--
-- Name: courses_terms_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('courses_terms_id_seq', 4, true);


--
-- Name: dictionary_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE dictionary_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.dictionary_id_seq OWNER TO postgres;

--
-- Name: dictionary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE dictionary_id_seq OWNED BY dictionary.id;


--
-- Name: dictionary_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('dictionary_id_seq', 16, true);


--
-- Name: evaluation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE evaluation_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.evaluation_id_seq OWNER TO postgres;

--
-- Name: evaluation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE evaluation_id_seq OWNED BY evaluation.id;


--
-- Name: evaluation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('evaluation_id_seq', 16, true);


--
-- Name: evaluation_items_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE evaluation_items_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.evaluation_items_id_seq OWNER TO postgres;

--
-- Name: evaluation_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE evaluation_items_id_seq OWNED BY evaluation_items.id;


--
-- Name: evaluation_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('evaluation_items_id_seq', 3, true);


--
-- Name: excercise_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE excercise_groups_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.excercise_groups_id_seq OWNER TO postgres;

--
-- Name: excercise_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE excercise_groups_id_seq OWNED BY excercise_groups.id;


--
-- Name: excercise_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('excercise_groups_id_seq', 5, true);


--
-- Name: labels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE labels_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.labels_id_seq OWNER TO postgres;

--
-- Name: labels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE labels_id_seq OWNED BY labels.id;


--
-- Name: labels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('labels_id_seq', 106, true);


--
-- Name: pages_access_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pages_access_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pages_access_id_seq OWNER TO postgres;

--
-- Name: pages_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pages_access_id_seq OWNED BY pages_access.id;


--
-- Name: pages_access_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pages_access_id_seq', 21, true);


--
-- Name: pages_attached_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pages_attached_files_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pages_attached_files_id_seq OWNER TO postgres;

--
-- Name: pages_attached_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pages_attached_files_id_seq OWNED BY pages_attached_files.id;


--
-- Name: pages_attached_files_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pages_attached_files_id_seq', 44, true);


--
-- Name: pages_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE pages_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pages_id_seq OWNER TO postgres;

--
-- Name: pages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE pages_id_seq OWNED BY pages.id;


--
-- Name: pages_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('pages_id_seq', 23, true);


--
-- Name: set_types_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE set_types_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.set_types_id_seq OWNER TO postgres;

--
-- Name: set_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE set_types_id_seq OWNED BY set_types.id;


--
-- Name: set_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('set_types_id_seq', 5, true);


--
-- Name: sets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sets_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.sets_id_seq OWNER TO postgres;

--
-- Name: sets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE sets_id_seq OWNED BY sets.id;


--
-- Name: sets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sets_id_seq', 14, true);


--
-- Name: settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE settings_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.settings_id_seq OWNER TO postgres;

--
-- Name: settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE settings_id_seq OWNED BY settings.id;


--
-- Name: settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('settings_id_seq', 15, true);


--
-- Name: solutions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE solutions_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.solutions_id_seq OWNER TO postgres;

--
-- Name: solutions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE solutions_id_seq OWNED BY solutions.id;


--
-- Name: solutions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('solutions_id_seq', 21, true);


--
-- Name: students_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE students_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.students_id_seq OWNER TO postgres;

--
-- Name: students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE students_id_seq OWNED BY students.id;


--
-- Name: students_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('students_id_seq', 14, true);


--
-- Name: students_in_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE students_in_groups_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.students_in_groups_id_seq OWNER TO postgres;

--
-- Name: students_in_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE students_in_groups_id_seq OWNED BY students_in_groups.id;


--
-- Name: students_in_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('students_in_groups_id_seq', 23, true);


--
-- Name: students_solutions_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE students_solutions_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.students_solutions_id_seq OWNER TO postgres;

--
-- Name: students_solutions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE students_solutions_id_seq OWNED BY students_solutions.id;


--
-- Name: students_solutions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('students_solutions_id_seq', 9, true);


--
-- Name: tasks_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tasks_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tasks_id_seq OWNER TO postgres;

--
-- Name: tasks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tasks_id_seq OWNED BY tasks.id;


--
-- Name: tasks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tasks_id_seq', 15, true);


--
-- Name: tasks_in_sets_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tasks_in_sets_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tasks_in_sets_id_seq OWNER TO postgres;

--
-- Name: tasks_in_sets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tasks_in_sets_id_seq OWNED BY tasks_in_sets.id;


--
-- Name: tasks_in_sets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tasks_in_sets_id_seq', 14, true);


--
-- Name: tasks_labels_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tasks_labels_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tasks_labels_id_seq OWNER TO postgres;

--
-- Name: tasks_labels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tasks_labels_id_seq OWNED BY tasks_labels.id;


--
-- Name: tasks_labels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('tasks_labels_id_seq', 31, true);


--
-- Name: unassigned_students_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE unassigned_students_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.unassigned_students_id_seq OWNER TO postgres;

--
-- Name: unassigned_students_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE unassigned_students_id_seq OWNED BY unassigned_students.id;


--
-- Name: unassigned_students_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('unassigned_students_id_seq', 53, true);


--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE users_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.users_id_seq OWNER TO postgres;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE users_id_seq OWNED BY users.id;


--
-- Name: users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('users_id_seq', 2, true);


--
-- Name: users_in_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE users_in_groups_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.users_in_groups_id_seq OWNER TO postgres;

--
-- Name: users_in_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE users_in_groups_id_seq OWNED BY users_in_groups.id;


--
-- Name: users_in_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('users_in_groups_id_seq', 3, true);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE "authorization" ALTER COLUMN id SET DEFAULT nextval('authorization_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE authorization_groups ALTER COLUMN id SET DEFAULT nextval('authorization_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE boxes ALTER COLUMN id SET DEFAULT nextval('boxes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE command_line_vars ALTER COLUMN id SET DEFAULT nextval('command_line_vars_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE courses ALTER COLUMN id SET DEFAULT nextval('courses_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE courses_set_types ALTER COLUMN id SET DEFAULT nextval('courses_set_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE courses_terms ALTER COLUMN id SET DEFAULT nextval('courses_terms_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE dictionary ALTER COLUMN id SET DEFAULT nextval('dictionary_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE evaluation ALTER COLUMN id SET DEFAULT nextval('evaluation_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE evaluation_items ALTER COLUMN id SET DEFAULT nextval('evaluation_items_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE excercise_groups ALTER COLUMN id SET DEFAULT nextval('excercise_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE labels ALTER COLUMN id SET DEFAULT nextval('labels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pages ALTER COLUMN id SET DEFAULT nextval('pages_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pages_access ALTER COLUMN id SET DEFAULT nextval('pages_access_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE pages_attached_files ALTER COLUMN id SET DEFAULT nextval('pages_attached_files_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE set_types ALTER COLUMN id SET DEFAULT nextval('set_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE sets ALTER COLUMN id SET DEFAULT nextval('sets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE settings ALTER COLUMN id SET DEFAULT nextval('settings_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE solutions ALTER COLUMN id SET DEFAULT nextval('solutions_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE students ALTER COLUMN id SET DEFAULT nextval('students_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE students_in_groups ALTER COLUMN id SET DEFAULT nextval('students_in_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE students_solutions ALTER COLUMN id SET DEFAULT nextval('students_solutions_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tasks ALTER COLUMN id SET DEFAULT nextval('tasks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tasks_in_sets ALTER COLUMN id SET DEFAULT nextval('tasks_in_sets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tasks_labels ALTER COLUMN id SET DEFAULT nextval('tasks_labels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE unassigned_students ALTER COLUMN id SET DEFAULT nextval('unassigned_students_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE users ALTER COLUMN id SET DEFAULT nextval('users_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE users_in_groups ALTER COLUMN id SET DEFAULT nextval('users_in_groups_id_seq'::regclass);


--
-- Data for Name: authorization; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO "authorization" VALUES (2, 2, 'student@matfyz.sk', '0cc175b9c0f1b6a831c399e269772661', 10, '2009-05-24 22:52:31');
INSERT INTO "authorization" VALUES (1, 1, 'admin', '0cc175b9c0f1b6a831c399e269772661', 31, '2009-05-24 23:16:36');


--
-- Data for Name: authorization_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO authorization_groups VALUES (1, 'administrator');
INSERT INTO authorization_groups VALUES (2, 'student');


--
-- Data for Name: boxes; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO boxes VALUES (8, 1, 'home', 'uvodny box', 'main');
INSERT INTO boxes VALUES (9, 2, 'login', 'prihlasovaci box', 'main');
INSERT INTO boxes VALUES (10, 1, 'menu', 'navigacia - solid box', 'navigation');
INSERT INTO boxes VALUES (11, 4, 'taskList', 'zoznam uloh', 'main');
INSERT INTO boxes VALUES (12, 3, 'logout', 'odhlasenie zo systemu', 'main');
INSERT INTO boxes VALUES (14, 6, 'taskImport', 'importovy formular ulohy', 'main');
INSERT INTO boxes VALUES (13, 5, 'taskEdit', 'editacny formular ulohy', 'tab1');
INSERT INTO boxes VALUES (18, 7, 'taskEdit', 'editacny formular pre pridavanie novej ulohy', 'tab1');
INSERT INTO boxes VALUES (19, 5, 'taskTags', 'tagy priradene k ulohe', 'tab2');
INSERT INTO boxes VALUES (17, 5, 'solutions', 'editacia riesenii k ulohe', 'tab3');
INSERT INTO boxes VALUES (20, 10, 'tagHierarchy', 'editacia tagov a hierarchii tagov', 'main');
INSERT INTO boxes VALUES (26, 13, 'setTypesEdit', 'zoznam a editacia typov zostav uloh', 'main');
INSERT INTO boxes VALUES (27, 14, 'setList', 'zoznam zostáv', 'main');
INSERT INTO boxes VALUES (28, 1, 'openSet', 'otvorena zostava uloh - solid box', 'open_set');
INSERT INTO boxes VALUES (23, 12, 'setEdit', 'editacia zostavy', 'tab1');
INSERT INTO boxes VALUES (29, 12, 'tasksInSet', 'úlohy priradené k zostave', 'tab2');
INSERT INTO boxes VALUES (30, 15, 'taskSearch', 'vyhladavanie ulohy', 'main');
INSERT INTO boxes VALUES (31, 1, 'searchForm', 'vyhladavaci formular - solid box', 'search_form');
INSERT INTO boxes VALUES (32, 5, 'taskUses', 'kde vsade bola uloha pouzita', 'tab4');
INSERT INTO boxes VALUES (33, 16, 'studentList', 'zoznam studentov', 'tab1');
INSERT INTO boxes VALUES (34, 16, 'studentGroups', 'skupiny studentov', 'tab2');
INSERT INTO boxes VALUES (36, 18, 'unsubmittedAssignments', 'neodovzdane zadania studenta', 'main');
INSERT INTO boxes VALUES (37, 19, 'viewAssignment', 'zobrazenie zadania', 'main');
INSERT INTO boxes VALUES (22, 11, 'adminCourses', 'administracia predmetov', 'tab1');
INSERT INTO boxes VALUES (39, 11, 'courseSetTypes', 'typy sad, ktore sa pouzivaju na danom predmete', 'tab2');
INSERT INTO boxes VALUES (40, 21, 'setEdit', 'pridavanie novej zostavy', 'tab1');
INSERT INTO boxes VALUES (43, 23, 'evaluate', 'hodnotenie', 'main');
INSERT INTO boxes VALUES (15, 1, 'ajaxActions', 'skripty, pouzivajuce sa v ajaxe', 'ajax');
INSERT INTO boxes VALUES (42, 22, 'studentsSolutions', 'riesenia odovzdane studentami', 'tab1');


--
-- Data for Name: command_line_vars; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO command_line_vars VALUES (1, 'filename', 'filename');
INSERT INTO command_line_vars VALUES (2, 'filename2', 'filename_without_extension');


--
-- Data for Name: courses; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO courses VALUES (3, 'Funkcionálne programovanie', 'FUNPROG');
INSERT INTO courses VALUES (1, 'Programovanie v Jave', 'JAVA');
INSERT INTO courses VALUES (2, 'Programovacie Paradigmy', 'PARA');


--
-- Data for Name: courses_set_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO courses_set_types VALUES (11, 1, 3, false, NULL, NULL);
INSERT INTO courses_set_types VALUES (12, 1, 2, false, NULL, NULL);
INSERT INTO courses_set_types VALUES (15, 1, 4, false, NULL, NULL);
INSERT INTO courses_set_types VALUES (16, 1, 1, false, NULL, NULL);
INSERT INTO courses_set_types VALUES (21, 3, 1, false, NULL, NULL);
INSERT INTO courses_set_types VALUES (18, 4, 1, true, 10, NULL);
INSERT INTO courses_set_types VALUES (17, 4, 5, true, NULL, NULL);
INSERT INTO courses_set_types VALUES (24, 4, 3, false, NULL, NULL);
INSERT INTO courses_set_types VALUES (20, 4, 2, false, 0, NULL);


--
-- Data for Name: courses_terms; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO courses_terms VALUES (1, 1, '2008/2009', 'L', true);
INSERT INTO courses_terms VALUES (2, 2, '2008/2009', 'L', true);
INSERT INTO courses_terms VALUES (3, 2, '2009/2010', 'Z', true);
INSERT INTO courses_terms VALUES (4, 2, '08/09', 'Z', true);


--
-- Data for Name: dictionary; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO dictionary VALUES (1, 'taskEdit', 'zadanie úlohy');
INSERT INTO dictionary VALUES (2, 'solutions', 'riešenia');
INSERT INTO dictionary VALUES (3, 'taskTags', 'tagy');
INSERT INTO dictionary VALUES (4, 'setEdit', 'nastavenia zostavy');
INSERT INTO dictionary VALUES (5, 'tasksInSet', 'úlohy');
INSERT INTO dictionary VALUES (6, 'taskUses', 'použitia');
INSERT INTO dictionary VALUES (7, 'studentList', 'zoznam');
INSERT INTO dictionary VALUES (8, 'studentGroups', 'skupiny');
INSERT INTO dictionary VALUES (9, 'pointsSystem', 'bodovanie');
INSERT INTO dictionary VALUES (10, 'setsAccess', 'nastavenia pre zadania');
INSERT INTO dictionary VALUES (11, 'courseSetTypes', 'typy zostáv');
INSERT INTO dictionary VALUES (12, 'adminCourses', 'predmety');
INSERT INTO dictionary VALUES (13, 'evaluationTab', 'prideľovanie bodov');
INSERT INTO dictionary VALUES (16, 'studentsSolutions', 'odovzdané riešenia');


--
-- Data for Name: evaluation; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO evaluation VALUES (16, 2, 1, 3, 'Dobra praca', false);


--
-- Data for Name: evaluation_items; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO evaluation_items VALUES (1, 'Cviko 1', 6, 4);
INSERT INTO evaluation_items VALUES (2, 'Cviko 2', 8, 4);
INSERT INTO evaluation_items VALUES (3, 'Cviko 3', 9, 4);


--
-- Data for Name: excercise_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO excercise_groups VALUES (2, 1, '18:10:00', 'Marek Tomacha; Marián Poník', 4, 'H3', 20);
INSERT INTO excercise_groups VALUES (5, 1, '16:55:00', 'Jano', 3, 'F128', 30);
INSERT INTO excercise_groups VALUES (1, 1, '16:30:00', 'Marián Poník, Marek Tomacha', 4, 'H3', 10);
INSERT INTO excercise_groups VALUES (3, 3, '13:00:00', 'Jozef', 4, 'H1', 12);


--
-- Data for Name: labels; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO labels VALUES (1, 'programovacia paradigma', 0);
INSERT INTO labels VALUES (3, 'programovací jazyk', 0);
INSERT INTO labels VALUES (31, 'logické programovanie', 1);
INSERT INTO labels VALUES (35, 'funkcionálne programovanie', 1);
INSERT INTO labels VALUES (36, 'procedurálne programovanie', 1);
INSERT INTO labels VALUES (37, 'objektovo-orientované programovanie', 1);
INSERT INTO labels VALUES (11, 'obtiažnosť', 0);
INSERT INTO labels VALUES (5, 'použité dátové štruktúry', 0);
INSERT INTO labels VALUES (18, 'pole', 5);
INSERT INTO labels VALUES (79, 'dynamické pole', 18);
INSERT INTO labels VALUES (80, 'matica', 18);
INSERT INTO labels VALUES (81, 'zoznam', 5);
INSERT INTO labels VALUES (82, 'graf', 5);
INSERT INTO labels VALUES (83, 'strom', 5);
INSERT INTO labels VALUES (84, 'spájaný zoznam', 81);
INSERT INTO labels VALUES (85, 'rad', 81);
INSERT INTO labels VALUES (86, 'zásobník', 81);
INSERT INTO labels VALUES (87, 'prioritný rad', 85);
INSERT INTO labels VALUES (88, 'halda', 83);
INSERT INTO labels VALUES (89, 'binárný strom', 83);
INSERT INTO labels VALUES (90, 'vyhľadávací strom', 83);
INSERT INTO labels VALUES (91, 'Pascal', 3);
INSERT INTO labels VALUES (92, 'C', 3);
INSERT INTO labels VALUES (93, 'C++', 3);
INSERT INTO labels VALUES (94, 'Haskell', 3);
INSERT INTO labels VALUES (95, 'Java', 3);
INSERT INTO labels VALUES (96, 'Prolog', 3);
INSERT INTO labels VALUES (97, 'SmallTalk', 3);
INSERT INTO labels VALUES (9, 'rekurzia', 4);
INSERT INTO labels VALUES (99, 'triedenie', 4);
INSERT INTO labels VALUES (100, 'vyhladavanie', 4);
INSERT INTO labels VALUES (101, 'quicksort', 99);
INSERT INTO labels VALUES (102, 'bubblesort', 99);
INSERT INTO labels VALUES (103, 'insertsort', 99);
INSERT INTO labels VALUES (104, 'mergesort', 99);
INSERT INTO labels VALUES (105, 'heapsort', 99);
INSERT INTO labels VALUES (4, 'použité algoritmy', 0);
INSERT INTO labels VALUES (98, 'backtracking', 11);
INSERT INTO labels VALUES (106, 'asdas', 98);


--
-- Data for Name: pages; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO pages VALUES (2, 'login', 'prihlasenie sa do aplikacie', 'log_in.tpl', 'home', true);
INSERT INTO pages VALUES (4, 'task_list', 'zoznam úloh', 'admin.tpl', 'tasks', false);
INSERT INTO pages VALUES (3, 'logout', 'odhlasenie sa zo systemu', 'admin.tpl', 'home', false);
INSERT INTO pages VALUES (6, 'task_import', 'import úlohy', 'admin.tpl', 'tasks', false);
INSERT INTO pages VALUES (5, 'task_edit', 'editácia úlohy', 'admin_tab.tpl', 'tasks', false);
INSERT INTO pages VALUES (7, 'task_add', 'zadávanie novej úlohy', 'admin_tab.tpl', 'tasks', false);
INSERT INTO pages VALUES (10, 'tag_hierarchy', 'editácia tagov a stromov tagov', 'admin.tpl', 'tasks', false);
INSERT INTO pages VALUES (1, 'home', 'domovska stranka', 'main.tpl', 'home', true);
INSERT INTO pages VALUES (13, 'set_types_edit', 'zoznam a editacia typov uloh', 'admin.tpl', 'excercises', false);
INSERT INTO pages VALUES (14, 'set_list', 'zoznam zostáv', 'admin.tpl', 'excercises', false);
INSERT INTO pages VALUES (12, 'set_edit', 'editacia zostavy uloh', 'admin_tab.tpl', 'excercises', false);
INSERT INTO pages VALUES (15, 'search_task', 'vyhladavanie ulohy', 'admin.tpl', 'tasks', false);
INSERT INTO pages VALUES (16, 'student_list', 'zoznam studentov', 'admin_tab.tpl', 'admin', false);
INSERT INTO pages VALUES (17, 'student_edit', 'editacia studenta', 'admin.tab', 'admin', false);
INSERT INTO pages VALUES (18, 'unsubmitted_assignments', 'neodovzdane zadania studenta', 'student.tpl', 'student', false);
INSERT INTO pages VALUES (19, 'view_assignment', 'zobrazenie zadania', 'student.tpl', 'student', false);
INSERT INTO pages VALUES (11, 'admin_courses', 'administracia predmetov', 'admin_tab.tpl', 'admin', false);
INSERT INTO pages VALUES (21, 'set_add', 'pridanie novej zostavy', 'admin_tab.tpl', 'excercises', false);
INSERT INTO pages VALUES (22, 'evaluation', 'hodnotenie študentov', 'admin_tab.tpl', 'excercises', false);
INSERT INTO pages VALUES (23, 'evaluate', 'vyhodnocovanie riešenia', 'admin.tpl', 'excercises', false);


--
-- Data for Name: pages_access; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO pages_access VALUES (1, 4, 1);
INSERT INTO pages_access VALUES (3, 3, 1);
INSERT INTO pages_access VALUES (4, 3, 2);
INSERT INTO pages_access VALUES (5, 5, 1);
INSERT INTO pages_access VALUES (6, 6, 1);
INSERT INTO pages_access VALUES (7, 7, 1);
INSERT INTO pages_access VALUES (8, 10, 1);
INSERT INTO pages_access VALUES (9, 11, 1);
INSERT INTO pages_access VALUES (10, 12, 1);
INSERT INTO pages_access VALUES (11, 13, 1);
INSERT INTO pages_access VALUES (12, 14, 1);
INSERT INTO pages_access VALUES (13, 15, 1);
INSERT INTO pages_access VALUES (14, 16, 1);
INSERT INTO pages_access VALUES (16, 18, 2);
INSERT INTO pages_access VALUES (17, 19, 2);
INSERT INTO pages_access VALUES (19, 21, 1);
INSERT INTO pages_access VALUES (20, 22, 1);
INSERT INTO pages_access VALUES (21, 23, 1);


--
-- Data for Name: pages_attached_files; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO pages_attached_files VALUES (1, 'include/js/taskEdit.js', 'javascript', 5);
INSERT INTO pages_attached_files VALUES (4, 'include/js/taskEdit.js', 'javascript', 7);
INSERT INTO pages_attached_files VALUES (5, 'include/js/tags.js', 'javascript', 10);
INSERT INTO pages_attached_files VALUES (6, 'include/js/tags.js', 'javascript', 5);
INSERT INTO pages_attached_files VALUES (7, 'include/js/sortable.js', 'javascript', 4);
INSERT INTO pages_attached_files VALUES (8, 'include/js/listing.js', 'javascript', 4);
INSERT INTO pages_attached_files VALUES (9, 'include/js/taskList.js', 'javascript', 4);
INSERT INTO pages_attached_files VALUES (11, 'include/js/listing.js', 'javascript', 11);
INSERT INTO pages_attached_files VALUES (12, 'css/listing.css', 'stylesheet', 11);
INSERT INTO pages_attached_files VALUES (13, 'include/js/adminCourses.js', 'javascript', 11);
INSERT INTO pages_attached_files VALUES (14, 'css/listing.css', 'stylesheet', 4);
INSERT INTO pages_attached_files VALUES (15, 'include/js/setEdit.js', 'javascript', 12);
INSERT INTO pages_attached_files VALUES (16, 'include/js/listing.js', 'javascript', 13);
INSERT INTO pages_attached_files VALUES (17, 'css/listing.css', 'stylesheet', 13);
INSERT INTO pages_attached_files VALUES (18, 'include/js/setEdit.js
', 'javascript', 13);
INSERT INTO pages_attached_files VALUES (19, 'include/js/scw.js', 'javascript', 12);
INSERT INTO pages_attached_files VALUES (20, 'include/js/listing.js', 'javascript', 14);
INSERT INTO pages_attached_files VALUES (21, 'css/listing.css', 'stylesheet', 14);
INSERT INTO pages_attached_files VALUES (24, 'include/js/listing.js', 'javascript', 15);
INSERT INTO pages_attached_files VALUES (25, 'css/listing.css', 'stylesheet', 15);
INSERT INTO pages_attached_files VALUES (26, 'include/js/taskList.js
', 'javascript', 15);
INSERT INTO pages_attached_files VALUES (27, 'include/js/listing.js', 'javascript', 5);
INSERT INTO pages_attached_files VALUES (28, 'css/listing.css', 'stylesheet', 5);
INSERT INTO pages_attached_files VALUES (29, 'include/js/listing.js', 'javascript', 16);
INSERT INTO pages_attached_files VALUES (30, 'css/listing.css', 'stylesheet', 16);
INSERT INTO pages_attached_files VALUES (31, 'include/js/studentList.js', 'javascript', 16);
INSERT INTO pages_attached_files VALUES (32, 'include/js/listing.js', 'javascript', 18);
INSERT INTO pages_attached_files VALUES (33, 'css/listing.css', 'stylesheet', 18);
INSERT INTO pages_attached_files VALUES (37, 'include/js/scw.js', 'javascript', 21);
INSERT INTO pages_attached_files VALUES (38, 'include/js/setEdit.js
', 'javascript', 21);
INSERT INTO pages_attached_files VALUES (39, 'css/taskSet.css', 'stylesheet', 19);
INSERT INTO pages_attached_files VALUES (40, 'include/js/listing.js', 'javascript', 22);
INSERT INTO pages_attached_files VALUES (41, 'css/listing.css', 'stylesheet', 22);
INSERT INTO pages_attached_files VALUES (42, 'include/js/evaluation.js', 'javascript', 22);
INSERT INTO pages_attached_files VALUES (43, 'include/js/evaluate.js', 'javascript', 23);
INSERT INTO pages_attached_files VALUES (44, 'include/js/opacityfunctions.js', 'javascript', 23);


--
-- Data for Name: set_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO set_types VALUES (2, 'rozcvička');
INSERT INTO set_types VALUES (4, 'projekt');
INSERT INTO set_types VALUES (3, 'midterm');
INSERT INTO set_types VALUES (5, 'domáca úloha');
INSERT INTO set_types VALUES (1, 'cvičenie');


--
-- Data for Name: sets; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO sets VALUES (1, 'Cvičenie 1', '2009-05-03 21:49:40.714', NULL, 1, 1, NULL);
INSERT INTO sets VALUES (2, 'Cvičenie 2', '2009-05-13 19:04:00', NULL, 1, 1, NULL);
INSERT INTO sets VALUES (7, 'paradigmy 10', '2009-01-14 13:00:00', NULL, 3, 1, NULL);
INSERT INTO sets VALUES (3, 'Rozcvička 1', '2009-06-01 15:00:00', '2009-07-17 18:00:00', 1, 1, NULL);
INSERT INTO sets VALUES (10, 'DU 2', '2009-05-13 12:00:00', '2009-05-27 12:00:00', 4, 5, NULL);
INSERT INTO sets VALUES (13, 'DU3', '2009-05-22 12:00:00', '2009-06-06 12:00:00', 4, 5, NULL);
INSERT INTO sets VALUES (11, 'DU 1', '2009-05-11 12:00:00', '2009-05-25 12:00:00', 4, 5, NULL);
INSERT INTO sets VALUES (12, 'midterm 1', '2009-05-17 12:00:00', '2009-05-17 16:00:00', 4, 3, NULL);
INSERT INTO sets VALUES (14, 'zostavicka', NULL, NULL, 4, 1, '1969-12-29');
INSERT INTO sets VALUES (6, 'Cviko 1', NULL, NULL, 4, 1, '2009-05-11');
INSERT INTO sets VALUES (8, 'Cviko 2', NULL, NULL, 4, 1, '2009-05-18');
INSERT INTO sets VALUES (9, 'Cviko 3', NULL, NULL, 4, 1, '2009-05-11');


--
-- Data for Name: settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO settings VALUES (2, 'allowed_tags', '<b><i><strong>', 0, 'ktore tagy su povolene v editacii riesenia (tusim)');
INSERT INTO settings VALUES (3, 'task_list_text_length', '65', 0, 'aky dlhy text sa ma ukazat v zozname uloh');
INSERT INTO settings VALUES (4, 'display_course_name_mode', 'short', 0, 'ci sa ma v systeme zobrazovat kratke alebo cele meno predmetu. Moze byt short alebo full');
INSERT INTO settings VALUES (5, 'display_terms', '0', 0, 'ci sa ma v systeme zobrazovat semester (alebo iba rok) (boolean)');
INSERT INTO settings VALUES (6, 'default_course_term_id', '4', 0, 'ktory predmet (jeho dana instancia - semester) sa v systeme bude pouzivat ako predvoleny');
INSERT INTO settings VALUES (10, 'auto_set_name', '0', 0, 'automaticke pomenovavanie zostav');
INSERT INTO settings VALUES (9, 'open_set_id', '6', 0, 'id otvorenej zostavy uloh');
INSERT INTO settings VALUES (11, 'max_file_size', '10', 0, 'maximalna velkost uploadovaneho suboru');
INSERT INTO settings VALUES (13, 'allowed_file_types', 'application/zip', 0, 'polovene typy suborov (oddelene ciarkou)');
INSERT INTO settings VALUES (14, 'multi_submitting_solution', 'disabled', 0, 'ci je povolene viacnasobne odovzdavanie riesenia. Moznosti su: disable (povolit iba jedno odoslanie na jedno zadanie), rewrite (povolit viac odoslani, pricom novsie prepise starsie) a multiple (povolit viac odoslanych suborov k jednemu zadaniu)');
INSERT INTO settings VALUES (15, 'publish_evaluation_immediatly', '0', 0, 'ci sa ma hodnotenie ukazat studentovi hned ako ho vyucujuci ulozi, alebo az ked vyucujuci publikuje hodnotenie, plati iba ked student nemal ziadne hodnotenie pred tym (ked len aktualizujem, tak is_published sa nemeni)');


--
-- Data for Name: solutions; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO solutions VALUES (20, 3, '<pre><code>div2(0, 0).<br/>div2(s(0), 0).<br/>div2(s(s(X)),s(Y)):-div2(X,Y).<br/></code></pre>', '');
INSERT INTO solutions VALUES (19, 4, '<a href="files/tasks/Fact.java">Fact.java</a>', '');
INSERT INTO solutions VALUES (21, 1, '<a href="files/tasks/C412.java">C412.java</a> asdasdasdasdasdasdasd', NULL);


--
-- Data for Name: students; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO students VALUES (3, 'Para', 'Digmová', NULL, 'para.digma@st.fmph.uniba.sk');
INSERT INTO students VALUES (13, 'Michal', 'Rada', NULL, 'rada@st.fmph.uniba.sk');
INSERT INTO students VALUES (14, 'Jano', 'Kordik', NULL, 'kordik.jan@gmail.com');
INSERT INTO students VALUES (1, 'Jozef', 'Učenlivý', NULL, 'ucenlivy@st.fmph.uniba.sk');
INSERT INTO students VALUES (2, 'Ondrej', 'Kockatý', 2, 'kocka@cube.com');
INSERT INTO students VALUES (9, 'Jánošík', 'Adam', NULL, 'adam@janosik.sk');
INSERT INTO students VALUES (6, 'Marek', 'Dovič', NULL, 'dove@azet.sk');
INSERT INTO students VALUES (12, 'Hugo', 'Drsný', NULL, NULL);
INSERT INTO students VALUES (5, 'Pavol', 'Kordik', NULL, 'kordik.pavol@gmail.com');
INSERT INTO students VALUES (4, 'Angelina', 'Stranícka', NULL, 'angelina@mail.ru');


--
-- Data for Name: students_in_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO students_in_groups VALUES (19, 5, 9, false);
INSERT INTO students_in_groups VALUES (23, 2, 9, true);
INSERT INTO students_in_groups VALUES (22, 2, 12, true);
INSERT INTO students_in_groups VALUES (2, 1, 5, true);
INSERT INTO students_in_groups VALUES (14, 3, 2, true);
INSERT INTO students_in_groups VALUES (9, 2, 4, true);
INSERT INTO students_in_groups VALUES (18, 5, 6, false);


--
-- Data for Name: students_solutions; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO students_solutions VALUES (5, 2, 6, '2009-05-19 17:52:19.205', 'files/solutions/PARA08-09/Cviko_1/KockatyOndrej.zip', '127.0.0.1');
INSERT INTO students_solutions VALUES (6, 2, 6, '2009-05-20 21:22:10.257', 'files/solutions/PARA08-09/Cviko_1/KockatyOndrej2.zip', '111.222.333.444');
INSERT INTO students_solutions VALUES (9, 2, 8, '2009-05-20 23:16:17.946', 'files/solutions/PARA08-09/Cviko_1/KockatyOndrej2.zip', '345.66.433.2');


--
-- Data for Name: tasks; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO tasks VALUES (1, 'Polynom', 'Definujte triedu Polynom, ktorá reprezentuje polynom v N-tého stupňa s reálnymi koeficientami. Pre danú triedu definujte konštruktor Polynom(double[] p), metódu toString(), ktorá polynóm pretrasnformuje do textovej reprezentácie(za ktorú sa nehanbíte), a  metódu double hodnota(double x), ktorá vypočíta hodnotu polynómu v bode x., pomocka: <a href="files/tasks/C41.java">C41.java</a>', true);
INSERT INTO tasks VALUES (5, 'Prehliadač fotiek', 'Naprogramujte malý prehliadač fotiek (súborov .jpg) v jednom adresári. Funkcie: nasledujúca, predchádzajúca, zmaž, slide show.', true);
INSERT INTO tasks VALUES (6, 'Opitý námorník', 'Po kruhovom móle polomeru 10 metrov sa tacká opitý námorník. Začína v strede kruhového móla, a v každom kroku urobí krok náhodným smerom, náhodnej dĺžky, najviac však 1 meter. Ak sa opitý námorník vzdiali viac ako 10 metrov od stredu móla, padne do mora. Simulujte jeho pohyb, polohu, počet krokov. Pokúste sa ho zobraziť graficky.', true);
INSERT INTO tasks VALUES (7, 'Guličky v krabici', 'Graficky simulujte pohyb N guličiek v obdľžnikovej krabici, pričom každá má svoju rýchlosť, farbu a smer. Vždy po M časových jednotkách prihoďte do krabice ďalšiu guličku, a simulujete viac guličiek.', true);
INSERT INTO tasks VALUES (8, 'ArrayQueue', 'Implementujte triedu ArrayQueue, ktorá implementuje interface QueueInterface z prednášky tak, že front reprezentujete jednorozmerným poľom.', true);
INSERT INTO tasks VALUES (9, 'Lineárny zoznam', 'Pomocou triedy Node<E> z prednášky definujte triedu List<E>  reprezentujúcu lineárny zoznam s následujúcimi metódami:

<pre><code>

public List()



public List(E a[]) - konštrukcia zoznamu z poľa



public boolean isEmpty()



public E head() throws EmptyListException



public List<E> tail() throws EmptyListException



public void setHead(E newElem) throws EmptyListException



public String toString() - textová reprezentácia zoznamu



public int size() - jeho dlžka



public void append(List<E> y) - prilepí zoznam y na koniec aktuálneho zoznamu

</code></pre>', true);
INSERT INTO tasks VALUES (10, 'Riedke matice', 'Riedke matice sú matice veľkých rozmerov, ktorých len malá časť prvkov je nenulových. Navrhnite vhodnú reprezentáciu riedkych matíc (zložitosťou úmernú počtu nenulových elementov matice), tak aby ste vedeli implementovať základné operácie sčitovanie a násobenia riedkych matíc. Implementujte ich na vašej dátovej reprezentácii.', true);
INSERT INTO tasks VALUES (11, 'Veľké čísla', 'Navrhnite triedu, ktorá reprezentuje veľké čísla v desiatkovej sústave. Jedna z možností, že si ich pamätáte po cifrách. Implementujte metódy add a mult na sčítanie a násobenie takýchto čísiel.', true);
INSERT INTO tasks VALUES (12, 'Kasa', 'Váš program prečíta zo súboru <a href="files/tasks/ucet.txt">ucet.txt</a> informácie o tovare a cenách z vášho posledného nákupu v supermarkete. Oddeľovačom je ; pričom riadok obsahuje názov tovaru, počet kusov/váhu a celkovú cenu. Vypíšte zákazníkovi pekne naformátovaný pokladničný blok so súčtom a DPH. Ceny sa udávajú na 2 desatinné miesta zarovnané doprava.', true);
INSERT INTO tasks VALUES (13, 'Determinant', 'Vo stupnom <a href="files/tasks/matica3.txt">matica3.txt</a> súbore je matica celých čísel 3x3. Vypočítajte determinant tejto matice.', true);
INSERT INTO tasks VALUES (15, 'asdasd', 'asdasdasdasdasd', false);
INSERT INTO tasks VALUES (2, 'Invarianty', 'V programe <a href="files/tasks/order.c">order.c</a> nahraďte výrazy @VYRAZi skutočnými výrazmi tak, aby program fungoval a aby platili uvedené invarianty na miestach, kde sú uvedené. (Invariant je logická podmienka, ktorá musí v danom mieste programu platiť vždy, keď vykonávanie prechádza daným miestom - v niektorých jazykoch sa takéto podmienky dajú zapísať pomocou príkazu assert). ', true);
INSERT INTO tasks VALUES (3, 'Celočíselné delenie v Prologu', 'Definujte predikat div2(X,Y), ktory plati, ak Y = X div 2

', true);
INSERT INTO tasks VALUES (4, 'Obmedzený faktoriál', 'Napíšte program na výpočet faktoriálu, ktorý

<ul><li>nepoužíva príkaz priradenia</li>

    <li>nepoužíva násobenie</li>

    <li>nepoužíva žiadne číselne konštanty.</li>

</ul>', true);


--
-- Data for Name: tasks_in_sets; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO tasks_in_sets VALUES (5, 1, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (6, 1, 8, 2, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (7, 1, 3, 3, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (8, 3, 9, 1, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (9, 3, 15, 2, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (10, 7, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (11, 8, 1, 1, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (12, 3, 1, 3, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (13, 3, 6, 4, NULL, NULL, NULL, NULL);
INSERT INTO tasks_in_sets VALUES (14, 9, 2, 1, 3, NULL, 'order.c', NULL);
INSERT INTO tasks_in_sets VALUES (3, 6, 8, 2, 3, NULL, 'ArrayQueue.java', 'uloha2');
INSERT INTO tasks_in_sets VALUES (2, 6, 5, 1, 3, NULL, 'Gulicky2.java', NULL);
INSERT INTO tasks_in_sets VALUES (1, 6, 1, 3, 2.5, 'komentarik.....sda ads ap f a f as fsa asd aks doa dlynom, ktorá reprezentuje polynom v N-tého stupňa s reálnymi koeficientami. Pre danú triedu definujte konštruktor Polynom(double[] p), metó', NULL, NULL);
INSERT INTO tasks_in_sets VALUES (4, 6, 7, 4, 2.5, NULL, 'Gulicky.java', NULL);


--
-- Data for Name: tasks_labels; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO tasks_labels VALUES (16, 3, 96);
INSERT INTO tasks_labels VALUES (17, 3, 31);
INSERT INTO tasks_labels VALUES (18, 4, 9);
INSERT INTO tasks_labels VALUES (19, 1, 95);
INSERT INTO tasks_labels VALUES (20, 1, 9);
INSERT INTO tasks_labels VALUES (22, 1, 86);
INSERT INTO tasks_labels VALUES (23, 1, 37);
INSERT INTO tasks_labels VALUES (24, 5, 18);
INSERT INTO tasks_labels VALUES (25, 5, 84);
INSERT INTO tasks_labels VALUES (26, 5, 95);
INSERT INTO tasks_labels VALUES (27, 5, 37);
INSERT INTO tasks_labels VALUES (28, 6, 95);
INSERT INTO tasks_labels VALUES (29, 6, 79);
INSERT INTO tasks_labels VALUES (30, 6, 37);
INSERT INTO tasks_labels VALUES (31, 1, 102);


--
-- Data for Name: unassigned_students; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO unassigned_students VALUES (51, 14, 4, true);
INSERT INTO unassigned_students VALUES (48, 2, 3, true);
INSERT INTO unassigned_students VALUES (47, 12, 3, true);


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO users VALUES (1, 'Peter', 'Jurčo', 'petejur@yahoo.com');
INSERT INTO users VALUES (2, 'Študent', 'Učenlivý', 'student@matfyz.sk');


--
-- Data for Name: users_in_groups; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO users_in_groups VALUES (1, 1, 1);
INSERT INTO users_in_groups VALUES (2, 2, 2);
INSERT INTO users_in_groups VALUES (3, 1, 1);


--
-- Name: authorization_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY authorization_groups
    ADD CONSTRAINT authorization_groups_pkey PRIMARY KEY (id);


--
-- Name: authorization_login_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY "authorization"
    ADD CONSTRAINT authorization_login_key UNIQUE (login);


--
-- Name: boxes_page_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY boxes
    ADD CONSTRAINT boxes_page_id_key UNIQUE (page_id, name);


--
-- Name: command_line_vars_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY command_line_vars
    ADD CONSTRAINT command_line_vars_pkey PRIMARY KEY (id);


--
-- Name: courses_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses
    ADD CONSTRAINT courses_name_key UNIQUE (name);


--
-- Name: courses_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses
    ADD CONSTRAINT courses_pkey PRIMARY KEY (id);


--
-- Name: courses_set_types_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses_set_types
    ADD CONSTRAINT courses_set_types_pkey PRIMARY KEY (id);


--
-- Name: courses_terms_course_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses_terms
    ADD CONSTRAINT courses_terms_course_id_key UNIQUE (course_id, year, term);


--
-- Name: courses_terms_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY courses_terms
    ADD CONSTRAINT courses_terms_pkey PRIMARY KEY (id);


--
-- Name: dictionary_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY dictionary
    ADD CONSTRAINT dictionary_pkey PRIMARY KEY (id);


--
-- Name: evaluation_items_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY evaluation_items
    ADD CONSTRAINT evaluation_items_pkey PRIMARY KEY (id);


--
-- Name: evaluation_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY evaluation
    ADD CONSTRAINT evaluation_pkey PRIMARY KEY (id);


--
-- Name: excercise_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY excercise_groups
    ADD CONSTRAINT excercise_groups_pkey PRIMARY KEY (id);


--
-- Name: labels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY labels
    ADD CONSTRAINT labels_pkey PRIMARY KEY (id);


--
-- Name: pages_access_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pages_access
    ADD CONSTRAINT pages_access_pkey PRIMARY KEY (id);


--
-- Name: pages_attached_files_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pages_attached_files
    ADD CONSTRAINT pages_attached_files_pkey PRIMARY KEY (id);


--
-- Name: pages_name_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pages
    ADD CONSTRAINT pages_name_key UNIQUE (name);


--
-- Name: pk_authorization_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY "authorization"
    ADD CONSTRAINT pk_authorization_id PRIMARY KEY (id);


--
-- Name: pk_boxes_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY boxes
    ADD CONSTRAINT pk_boxes_id PRIMARY KEY (id);


--
-- Name: pk_pages_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pages
    ADD CONSTRAINT pk_pages_id PRIMARY KEY (id);


--
-- Name: pk_users_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT pk_users_id PRIMARY KEY (id);


--
-- Name: set_types_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY set_types
    ADD CONSTRAINT set_types_pkey PRIMARY KEY (id);


--
-- Name: sets_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY sets
    ADD CONSTRAINT sets_pkey PRIMARY KEY (id);


--
-- Name: solutions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY solutions
    ADD CONSTRAINT solutions_pkey PRIMARY KEY (id);


--
-- Name: students_auth_id_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY students
    ADD CONSTRAINT students_auth_id_key UNIQUE (auth_id);


--
-- Name: students_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY students
    ADD CONSTRAINT students_pkey PRIMARY KEY (id);


--
-- Name: students_solutions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY students_solutions
    ADD CONSTRAINT students_solutions_pkey PRIMARY KEY (id);


--
-- Name: tasks_labels_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tasks_labels
    ADD CONSTRAINT tasks_labels_pkey PRIMARY KEY (id);


--
-- Name: tasks_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tasks
    ADD CONSTRAINT tasks_pkey PRIMARY KEY (id);


--
-- Name: users_email_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_email_key UNIQUE (email);


--
-- Name: users_in_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY users_in_groups
    ADD CONSTRAINT users_in_groups_pkey PRIMARY KEY (id);


--
-- Name: fki_; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_ ON tasks_labels USING btree (task_id);


--
-- Name: fki_evaluation_item_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_evaluation_item_id ON evaluation USING btree (item_id);


--
-- Name: fki_excercise_groups_course_term_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_excercise_groups_course_term_id ON excercise_groups USING btree (course_term_id);


--
-- Name: fki_sets_course_term_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_sets_course_term_id ON sets USING btree (course_term_id);


--
-- Name: fki_sets_set_type_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_sets_set_type_id ON sets USING btree (set_type_id);


--
-- Name: fki_tasks_labels_label_id_labels_id; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_tasks_labels_label_id_labels_id ON tasks_labels USING btree (label_id);


--
-- Name: authorization_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY "authorization"
    ADD CONSTRAINT authorization_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(id);


--
-- Name: boxes_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY boxes
    ADD CONSTRAINT boxes_page_id_fkey FOREIGN KEY (page_id) REFERENCES pages(id);


--
-- Name: courses_set_types_course_term_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY courses_set_types
    ADD CONSTRAINT courses_set_types_course_term_id_fkey FOREIGN KEY (course_term_id) REFERENCES courses_terms(id);


--
-- Name: courses_set_types_set_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY courses_set_types
    ADD CONSTRAINT courses_set_types_set_type_id_fkey FOREIGN KEY (set_type_id) REFERENCES set_types(id);


--
-- Name: courses_terms_course_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY courses_terms
    ADD CONSTRAINT courses_terms_course_id_fkey FOREIGN KEY (course_id) REFERENCES courses(id);


--
-- Name: evaluation_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY evaluation
    ADD CONSTRAINT evaluation_item_id_fkey FOREIGN KEY (item_id) REFERENCES evaluation_items(id);


--
-- Name: evaluation_items_course_term_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY evaluation_items
    ADD CONSTRAINT evaluation_items_course_term_id_fkey FOREIGN KEY (course_term_id) REFERENCES courses_terms(id);


--
-- Name: evaluation_items_set_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY evaluation_items
    ADD CONSTRAINT evaluation_items_set_id_fkey FOREIGN KEY (set_id) REFERENCES sets(id);


--
-- Name: evaluation_student_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY evaluation
    ADD CONSTRAINT evaluation_student_id_fkey FOREIGN KEY (student_id) REFERENCES students(id);


--
-- Name: excercise_groups_course_term_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY excercise_groups
    ADD CONSTRAINT excercise_groups_course_term_id_fkey FOREIGN KEY (course_term_id) REFERENCES courses_terms(id);


--
-- Name: pages_access_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY pages_access
    ADD CONSTRAINT pages_access_group_id_fkey FOREIGN KEY (group_id) REFERENCES authorization_groups(id);


--
-- Name: pages_access_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY pages_access
    ADD CONSTRAINT pages_access_page_id_fkey FOREIGN KEY (page_id) REFERENCES pages(id);


--
-- Name: pages_attached_files_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY pages_attached_files
    ADD CONSTRAINT pages_attached_files_page_id_fkey FOREIGN KEY (page_id) REFERENCES pages(id);


--
-- Name: sets_course_term_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY sets
    ADD CONSTRAINT sets_course_term_id_fkey FOREIGN KEY (course_term_id) REFERENCES courses_terms(id);


--
-- Name: sets_set_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY sets
    ADD CONSTRAINT sets_set_type_id_fkey FOREIGN KEY (set_type_id) REFERENCES set_types(id);


--
-- Name: solutions_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY solutions
    ADD CONSTRAINT solutions_task_id_fkey FOREIGN KEY (task_id) REFERENCES tasks(id);


--
-- Name: students_auth_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY students
    ADD CONSTRAINT students_auth_id_fkey FOREIGN KEY (auth_id) REFERENCES "authorization"(id);


--
-- Name: students_in_groups_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY students_in_groups
    ADD CONSTRAINT students_in_groups_group_id_fkey FOREIGN KEY (group_id) REFERENCES excercise_groups(id);


--
-- Name: students_in_groups_student_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY students_in_groups
    ADD CONSTRAINT students_in_groups_student_id_fkey FOREIGN KEY (student_id) REFERENCES students(id);


--
-- Name: students_solutions_set_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY students_solutions
    ADD CONSTRAINT students_solutions_set_id_fkey FOREIGN KEY (set_id) REFERENCES sets(id);


--
-- Name: students_solutions_student_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY students_solutions
    ADD CONSTRAINT students_solutions_student_id_fkey FOREIGN KEY (student_id) REFERENCES students(id);


--
-- Name: tasks_in_sets_set_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tasks_in_sets
    ADD CONSTRAINT tasks_in_sets_set_id_fkey FOREIGN KEY (set_id) REFERENCES sets(id);


--
-- Name: tasks_in_sets_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tasks_in_sets
    ADD CONSTRAINT tasks_in_sets_task_id_fkey FOREIGN KEY (task_id) REFERENCES tasks(id);


--
-- Name: tasks_labels_label_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tasks_labels
    ADD CONSTRAINT tasks_labels_label_id_fkey FOREIGN KEY (label_id) REFERENCES labels(id);


--
-- Name: tasks_labels_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tasks_labels
    ADD CONSTRAINT tasks_labels_task_id_fkey FOREIGN KEY (task_id) REFERENCES tasks(id);


--
-- Name: unassigned_students_course_term_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY unassigned_students
    ADD CONSTRAINT unassigned_students_course_term_id_fkey FOREIGN KEY (course_term_id) REFERENCES courses_terms(id);


--
-- Name: unassigned_students_student_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY unassigned_students
    ADD CONSTRAINT unassigned_students_student_id_fkey FOREIGN KEY (student_id) REFERENCES students(id);


--
-- Name: users_in_groups_authorization_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY users_in_groups
    ADD CONSTRAINT users_in_groups_authorization_id_fkey FOREIGN KEY (authorization_id) REFERENCES "authorization"(id);


--
-- Name: users_in_groups_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY users_in_groups
    ADD CONSTRAINT users_in_groups_group_id_fkey FOREIGN KEY (group_id) REFERENCES authorization_groups(id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

