<?php 

/**
 * @abstract prepise $datum na zvoleny format
 * @param int timestamp $datum 
 * @param string $format format to_sql2, to_sql, to_display, to_display_with_time, to_display_with_zero, to_display_day_month, to_display_weekday 
 */
function dateFormat($datum, $format) {
	if (trim($datum)=='') return NULL;
	$mesiace = array('1'=>'január','2'=>'február','3'=>'marec','4'=>'apríl','5'=>'máj','6'=>'jún','7'=>'júl','8'=>'august','9'=>'september','10'=>'október','11'=>'november','12'=>'december');
	$dni = array('1'=>'pondelok','2'=>'utorok','3'=>'stredu','4'=>'�tvrtok','5'=>'piatok','6'=>'sobota','7'=>'nedeľa');
	$dni_rel = array(1=>'včera',0=>'dnes',-1=>'zajtra');

	switch ($format) {
		case 'to_sql2':
			return 'cast(\''.date('Y/m/d', strtotime($datum)).'\' as date)';
		break;
		case 'to_sql':
			return date('Y-m-d', strtotime($datum));
		break;
		case 'to_display':
			return date('j.n.Y', strtotime($datum));			
		break;
		case 'to_display_with_time':
			return date('j.n.Y H:i', strtotime($datum));
		break;		
		case 'to_display_with_zero':
			return date('d.m.Y', strtotime($datum));
		break;			
		case 'to_display_day_month':
			return date('d.m.', strtotime($datum));
		break;		
		case 'to_display_weekday_short':
			return $dni[date('N', strtotime($datum))];
		break;
		case 'to_filename':
			return date('Ymd-His', strtotime($datum));
		break;	
		case 'month_word':
			return date('d.', strtotime($datum)).$mesiace[date('n', strtotime($datum))]." ".date('Y', strtotime($datum));
		break;	
		case 'my_format':
		    $diff = dateDiff(date("Y-m-d"),date('Y-m-d', strtotime($datum)));
			if(array_key_exists($diff.'',$dni_rel))
			  return $dni_rel[$diff]." ".date('G:i', strtotime($datum));
			else  
			  return $dni[date('N', strtotime($datum))]." ".date('d.m.y', strtotime($datum))." ".date('G:i', strtotime($datum));
		break;		
		case 'my_format_nbsp':
		    $diff = dateDiff(date("Y-m-d"),date('Y-m-d', strtotime($datum)));
			if(array_key_exists($diff.'',$dni_rel))
			  return $dni_rel[$diff]."&nbsp;".date('G:i', strtotime($datum));
			else  
			  return $dni[date('N', strtotime($datum))]."&nbsp;".date('j.n.y', strtotime($datum))."&nbsp;".date('G:i', strtotime($datum));
		break;		
		
		
	}	
}

//vracia rozdiel dvoch datumov (YYYY-MM-DD) v dnoch
function dateDiff($date1,$date2){
  $date1_array = explode("-",$date1);
  $date2_array = explode("-",$date2);
  $timestamp1 = mktime(0,0,0,$date1_array[1],$date1_array[2],$date1_array[0]);
  $timestamp2 = mktime(0,0,0,$date2_array[1],$date2_array[2],$date2_array[0]);
  return round(($timestamp1-$timestamp2)/86400);
}

//vracia rozdiel dvoch datumov (datetime) (YYYY-MM-DD HH:MM:SS) v sekundach
function datetimeDiff($date1,$date2){
  $datetime1_array = explode(" ",$date1);
  $datetime2_array = explode(" ",$date2);
  $date1_array = explode("-",$datetime1_array[0]);
  $date2_array = explode("-",$datetime2_array[0]);
  $time1_array = explode(":",$datetime1_array[1]);
  $time2_array = explode(":",$datetime2_array[1]);  
  $timestamp1 = mktime($time1_array[0],$time1_array[1],$time1_array[2],$date1_array[1],$date1_array[2],$date1_array[0]);
  $timestamp2 = mktime($time2_array[0],$time2_array[1],$time2_array[2],$date2_array[1],$date2_array[2],$date2_array[0]);
  return $timestamp1-$timestamp2;
}

//funkcia vrati skratku zo stringu - prvych n pismen slov
function abbr($string,$separator=". ",$n=1,$onlyFirstUpper=true){
	$words = explode(" ",$string);
	$out = "";
	foreach($words as $word){
		$out .= strtoupper($word[0]);
		for($i=1;$i<$n;$i++)
			if($onlyFirstUpper)
				$out .= $word[$i];
			else
				$out .= strtoupper($word[$i]);
		$out .= $separator; 
	}
	return $out;	
}

//to iste co abbr, akurat vynecha posledne slovo - pouziva sa pri inicialkach krstnych mien
function initials($string,$separator=". "){
	$words = explode(" ",$string);
	$surname = array_pop($words); #odstranenie priezviska
	$out = "";
	foreach($words as $word)
		$out .= strtoupper($word[0]).$separator;
	return $out.ucfirst($surname);
}

function random_password($chars = 8) {
   $letters = 'abcefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
   return substr(str_shuffle($letters), 0, $chars);
}

function bez_diakritiky($string){
	echo $string;
	return StrTr($string, "áäčďéěëíňóöôňřšťúůüýžľÁÄČĎÉĚËÍŇÓÖŘŠŤÚŮÜÝŽ", "aacdeeeinooonrstuuuyzlAACDEEEINOORSTUUUYZ");	
}

function normalize ($string) {
    $table = array(
        'Š'=>'S', 'š'=>'s', 'Đ'=>'Dj', 'đ'=>'dj', 'Ž'=>'Z', 'ž'=>'z', 'Č'=>'C', 'č'=>'c', 'Ć'=>'C', 'ć'=>'c',
        'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A', 'Å'=>'A', 'Æ'=>'A', 'Ç'=>'C', 'È'=>'E', 'É'=>'E',
        'Ê'=>'E', 'Ë'=>'E', 'Ì'=>'I', 'Í'=>'I', 'Î'=>'I', 'Ï'=>'I', 'Ñ'=>'N', 'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O',
        'Õ'=>'O', 'Ö'=>'O', 'Ø'=>'O', 'Ù'=>'U', 'Ú'=>'U', 'Û'=>'U', 'Ü'=>'U', 'Ý'=>'Y', 'Þ'=>'B', 'ß'=>'Ss',
        'à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a', 'å'=>'a', 'æ'=>'a', 'ç'=>'c', 'è'=>'e', 'é'=>'e',
        'ê'=>'e', 'ë'=>'e', 'ì'=>'i', 'í'=>'i', 'î'=>'i', 'ï'=>'i', 'ð'=>'o', 'ñ'=>'n', 'ò'=>'o', 'ó'=>'o',
        'ô'=>'o', 'õ'=>'o', 'ö'=>'o', 'ø'=>'o', 'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'ý'=>'y', 'ý'=>'y', 'þ'=>'b',
        'ÿ'=>'y', 'Ŕ'=>'R', 'ŕ'=>'r', 'ď'=>'d', 'ě'=>'e', 'ň'=>'n', 'ř'=>'r', 'ť'=>'t', 'ů'=>'u', 'ü'=>'u',
        'ľ'=>'l', 'ĺ'=>'l', 'Ŕ'=>'R', 'Ď'=>'D', 'Ě'=>'E', 'Ň'=>'N', 'Ř'=>'R', 'Ť'=>'T', 'Ů'=>'U', 'Ü'=>'U',
        'Ľ'=>'L', 'Ĺ'=>'L', 
    );
   
    return strtr($string, $table);
}

function safeFilename($string){
	$string = normalize($string);
	$string = strtr($string," \/|<>*?:","_---^^#&%"); 
	$string = str_replace("\"","@",$string); //"	
	return $string;
}

function dopln_nuly($number,$count,$null="0"){
	return str_repeat($null,($count-strlen($number.""))).$number;
}

function findUnusedFilename($dir, $name){
	if(!file_exists($dir.$name))
		return $name; 
	$name_parts = explode(".",$name);
	$file_type = array_pop($name_parts);
	$file_name = implode(".",$name_parts);
	$counter = 2;
	while(file_exists($dir.$file_name.$counter.".".$file_type))
		$counter++;
	return $file_name.$counter.".".$file_type;
}

/**
 * Skrati text tak, ze ma maximalne $char_count znakov a odreze z konca text po poslednu medzeru v retazci.
 * Ak je retazec kratsi ako $char_count vrati retazec
 */
function shortenedText($text,$char_count){
	if(strlen($text)<$char_count)
		return $text;
	return substr($text,0,strrpos(substr($text,0,$char_count)," "))."... ";
}

/**
 * Ak uz raz odosles header, tak nemozes stranku presmerovat. Da sa to spravit cez JS
 */
function JSredirect($page){
	echo "<script type='text/javascript'>location.href = '$page'</script>";
}

function JSrefresh(){
	echo "<script type='text/javascript'>location.href = location.href</script>";
}

/**
 * Vrati slovo po cislovke v spravnom tvare
 * napr. 4 ulohy, ale 5 uloh
 * pouzitie: wordVariation(4,array(0=>'uloh',1=>'uloha',2=>'ulohy',5=>'uloh'));
 */
function wordVariation($count,$variations){
	$last = '';
	foreach($variations as $key=>$word){
		if($key>$count)
			return $last;
		$last = $word;
	}
	return $last;
}

function dayOfWeek($day,$start=1){
	$weekDays = array($start=>"Pon","Uto","Str","Štv","Pia","Sob","Ned");
	return $weekDays[$day];
}
?>