//znovunacita box a nastavi dalsiu stranu listingu
//zatial spravene iba pre listingy v boxe na pozicii main
function displayListingPage(lname,lpage,filter,box_position){
	//ak je momentalne zobrazeny aspon jeden riadok, tak do prvej bunky v lavom hornom rohu hodime animovany loading gif
	if(byId(lname))
		byId(lname).rows[0].cells[0].innerHTML = '<img src="images/listing/loader.gif" width="16px" height="16px" alt="loading..." />';
	else	
		byId("listingWrapper_"+lname).innerHTML = '<span class="noResultMessage">Načítavám...</span>';

	//ked je nastavene $attachBoxId v box.class, tak sa pripoji jeden skryty div ku kazdemu boxu s jeho IDckom
	var box_id = byId("boxID_"+box_position).innerHTML;
	
	//zoberieme vsetky GET parametre stranky (okrem page)
	var params = location.href.split("&");
	params[0]="";
	var paramString = params.join("&")+"&listing="+lname+"&listing_page="+lpage+"&ajax=1&filter="+urlencode(filter)+"&stripslashes=1&escape=1";

	xmlHttp=GetXmlHttpObject()
	if (xmlHttp==null)
	{
	  //prehliadac nepodporuje AJAX, predpoklada sa, ze v akademickom prostredi sa taketo prehliadace uz nevyskytuju, iba ak kvoli vedeckym ucelom
	  alert('Používate starší prehliadač, s ktorým nemusí systém fungovať správne. Použite napríklad Mozillu Firefox :)');
	  return;
	}   
	//byId(contentBoxID).innerHTML = "Načítavám..."
	xmlHttp.onreadystatechange=function(){
		if(xmlHttp.readyState==4)
			byId("listingWrapper_"+lname).innerHTML = xmlHttp.responseText;
			//ts_makeSortable(byId(lname));
	}; 
	xmlHttp.open("POST","index.php?page=showBox&box_id="+box_id+paramString,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.send("");			
}

//zoberiem vsetky inputy z kontajnera (druhy arg.) a filtrujem podla nich
//parametre inputu:
//	name - meno stlpca vlistingu
//  value - hodnota, podla ktorej filtrujeme
//  class - typ (ilike, equal, exact...)
function filterListing(lname,container,box_position){
	var filterItems = new Array();
	var filters = container.getElementsByTagName("input");
	for(i=0;i<filters.length;i++){
		if(filters[i].value != ""){
			//ak meno obsahuje bodku, tak sa odvolava na tabulku a tam uvodzovky davat nemozeme
			var quote = (filters[i].name.search(".")==-1)?'"':'';
			if(filters[i].className == "match_ilike")
				filterItems[filterItems.length] = quote+filters[i].name+quote+' ilike \'%'+filters[i].value+'%\'';
			if(filters[i].className == "match_equal")
					filterItems[filterItems.length] = quote+filters[i].name+quote+' = \''+filters[i].value+'\'';
			if(filters[i].className == "match_exact")
				filterItems[filterItems.length] = filters[i].value;
		}			
	}
	var cond = "";
	if(box_position == undefined)
		box_position = "main";
	if(filterItems.length>0)
		cond = "("+filterItems.join(") AND (")+")";
	displayListingPage(lname,1,cond,box_position);
}

//function is calling on onclick action, when we want to show or hide sublisting table in listing row
function displaySublisting(listing_name,row_id){
	var row = document.getElementById(listing_name+'_subqueryRow'+row_id);
	if(row){
	  if(row.className=='subqueryRow hidden')
	  	row.className = 'subqueryRow';
	  else
	  	row.className='subqueryRow hidden';
	}
	else
	  alert('Chyba v zdrojovom kode: \n objavila sa chyba pri naviazani onclick eventu na riadok listingu');
	
}

function changeRowBGColor(elem, color){
  var cells = elem.cells;
  for(i=1; i<cells.length; i++)
    cells[i].style.backgroundColor=color;
}

//makeEditable - general version for listings
/*
	params:
	id - identificator
	fields - array of strings, each of them is name of column we want make editable
	replacements - what kind of edit item has to replace original text 
				   it can be "text" for input type=text
				   			 "function" for user defined function (can be used e.g. for select)
				   			 "button" for save button
*/
function makeRowEditable(id,fields,replacements,saveFunctionName){
	var elem = new Array();
	var widths = new Array();
	for(var i=0;i<fields.length;i++){
		elem[i] = byId(fields[i]+"_box_"+id);
		widths[i] = Math.max((elem[i].innerHTML.length+4),15);
		if(replacements[i] == "text")
			elem[i].innerHTML = "<input type='text' id='edit_"+fields[i]+id+"' value='"+elem[i].innerHTML+"' style='width:"+widths[i]+"ex' onkeyup='saveIfEnter(event,\""+saveFunctionName+"\","+id+")'/>";
		if(replacements[i] == "function")
			elem[i].innerHTML = eval(fields[i]+"Replace("+id+",'"+elem[i].innerHTML+"')");
		if(replacements[i] == "button"){
			elem[i].innerHTML = "<div id='hiddenBeforeButtonContent"+id+"' style='display:none'>"+elem[i].innerHTML+"</div><input type='button' onclick='"+saveFunctionName+"("+id+")' value='ulož' id='savebutton"+id+"'/>";
		}	
	}
}

//used on inputs for replacing <form> functionality of pressed-enter-submit
function saveIfEnter(e,func,id){
     var key;
     if(window.event) key = window.event.keyCode;     //IE
     else key = e.which;     //firefox
     if(key == 13) eval(func+"("+id+")");	
}

//saveData - general version for listing
function saveRowData(id,fields,replacements,table){
	var paramStr = "";
	var values = new Array();
	for(var i=0;i<fields.length;i++){
		values[i] = byId("edit_"+fields[i]+id).value;
		if(replacements[i]!="button")
			paramStr += fields[i]+"="+urlencode(values[i])+"&";
	}
	paramStr += "where=id="+id+"&stripslashes=1&escape=1";
	databaseRequest(table,
					"save",
					paramStr,
					function(){
						byId("savebutton"+id).value = "Ukladám...";
						byId("savebutton"+id).disabled = "disabled";
					},
					function(){
						if(xmlHttp.readyState==4){
							if(xmlHttp.responseText=='OK'){
								var elem = new Array();
								for(var i=0;i<fields.length;i++){
									elem[i] = byId(fields[i]+"_box_"+id);
									if(replacements[i]=="text")
										elem[i].innerHTML = values[i];
									else if(replacements[i]=="select"){
										var selects = elem[i].getElementsByTagName("select");
										elem[i].innerHTML = selects[0].options[selects[0].selectedIndex].text;
									}
									else if(replacements[i]=="button"){
										elem[i].innerHTML = byId("hiddenBeforeButtonContent"+id).innerHTML;
									}
									else if(replacements[i]=="none"){
									}
									else{ //ak nie je ani jedneho typu, vrati samotny text z parametra
										elem[i].innerHTML = replacements[i];
									}
								}	
							}
							else{
								alert("chyba: "+xmlHttp.responseText);
								byId("savebutton"+id).value = "ulož";
								byId("savebutton"+id).disabled = false;
							}
						}
					});
}