<?php

/**
 * @abstract This class allows work with PostgreSQL database as a simple object
 */
class pgDB{
	private $dbhost;
	private $dbport;
	private $dbname;
	private $dbuser;
	private $dbpass;
	private $dblink;
	private $error_text;
	private $errors;
	private $connected;
	//TODO: zoznam tabuliek
	private $tables;
	
	/**
	 * @abstract Constructor provides initiation of object vars and connection to the database. 
	 * Default vars it gets from config file. 
	 */
	function __construct($resource=null){
		if($resource===null){
			$db = getDBDefaults();
			$this->connect($db['name'],$db['port'],$db['host'],$db['user'],$db['pass']);
		}
		else
			$this->createObjectFromResource($resource);
	}	
	
	
	function createObjectFromResource($resource){
		//TODO
	}	
	
	/**
	 * @abstract Function connect provides initiation of object vars and connection to the database
	 * @param string $name Name of the database
	 * @param string $port Port of the postgres service
	 * @param string $host Server on which we providing our database
	 * @param string $user Username with which we log-in to the database
	 * @param string $pass Password with which we log-in to the database
	 */
	function connect($name,$port,$host,$user,$pass){
		$this->dbhost = $host;
		$this->dbport = $port;
		$this->dbuser = $user;
		$this->dbpass = $pass;
		$this->dbname = $name;
		$this->errors = array();
		$this->error_text = array("db_connection"=>"Can't connect to database. Check constructor of postgresDB object.");
		//connection to the database
		if(!$this->dblink = pg_connect("host=".$this->dbhost." port=".$this->dbport." dbname=".$this->dbname." user=".$this->dbuser." password=".$this->dbpass))
			$this->errors['db_connection'] = true;
		$this->connected = $this->dblink !== false;
	}
	
	function getResource(){
		return $this->dblink;
	}
	
}


?>