<?php
class coursesTermsTable extends pgTable{
  protected $table_name = "courses_terms";
  public $course;
  
  public function __construct(){
  	parent::__construct();
  	$this->course = new coursesTable;
  }
  
  /**
   * po tom ako loadnem riadok loadnem aj ulohu a aj zostavu a mozem tak k nim priamo pristupovat
   */
  public function loadWhere($condition){
  	if(parent::loadWhere($condition)){
  		return $this->course->load($this->get('course_id'));
  	}
  	else
  		return false;
  }
  
  public function getName($user){
  	$course_name_mode = $user->getSetting('display_course_name_mode');
	$display_terms = $user->getSetting('display_terms');
	$name = ($course_name_mode == 'short')?$this->course->get("short_name"):$this->course->get("name");
	$term = $display_terms?" ".$this->get("term")."S":"";
	return $name." ".$this->get("year").$term;
  }
  
  public function loadDefault($user){
  	$default_course_term_id = $user->getSetting('default_course_term_id');
  	return $this->load($default_course_term_id);
  }
  
  public function getActiveTerms(){
  	return $this->getMyRows('is_active');
  }
  
  public function getCoursesCombo($name,$selected,$user,$empty=false,$selectParams=''){
	$course_name_mode = $user->getSetting('display_course_name_mode');
	$display_terms = $user->getSetting('display_terms');
	$default_course_term_id = $user->getSetting('default_course_term_id');
	$coursesTable = new coursesTable;
	$allTerms = $this->getActiveTerms();
	$allCourses = $coursesTable->getMyRows();
	foreach($allCourses as $course)
		$courses[$course->get('id')] = $course_name_mode=='short'?$course->get('short_name'):$course->get('name');
	foreach($allTerms as $term){
		$terms[$term->get('id')] = $courses[$term->get('course_id')]." ".$term->get('year');
		if($display_terms)
			$terms[$term->get('id')] .= " ".$term->get("term")."S";
	}
	$html = "<select name=$name $selectParams>";
	if($empty)
		$html .= "<option></option>";
	foreach($terms as $key=>$term){
    	$html .= "<option value='{$key}'";
		if($key==$selected || ($selected === null && $key==$default_course_term_id))
			$html .= " selected='selected'";
		$html .= ">{$term}</option>";
	}
	$html .= "</select>";
	return $html;
  }
  
  /**
   * Vrati typy zostav, ktore su priradene k tomuto predmetu
   */
  public function getMyTypes(){
  	$stypes = new setTypesTable;
  	return $stypes->getRows("SELECT set_type_id as id FROM courses_set_types WHERE course_term_id = ".$this->get("id"));
  }
  
} 
?>