<?php
class tasksTable extends pgTable{
  protected $table_name = "tasks";
  
  /**
   * Listing, ktory sa pouziva aj pri filtrovanom zozname, aj pri zobrazeni vysledkov vyhladavania uloh
   */
  public function getTaskListing($page,$add_filter=""){
		$actions = "<a href='index.php?page=task_edit&task_id={id}' class='button'>edituj</a>&nbsp;";
		$actions .= "<a href='index.php?page=task_edit&choosen_task_id={id}' class='button'>vyber</a>&nbsp;";
		$actions .= "<a href='javascript:deleteTask({id},\"{name}\",\"{last_use}\")' class='button'>vymaž</a>&nbsp;";
		$list = new listing("SELECT *, tasks.text AS text2, ts.last_use FROM tasks 
							 LEFT JOIN (SELECT task_id,max(date_from)AS last_use FROM tasks_in_sets AS ts
					           			INNER JOIN sets ON sets.id=ts.set_id
					           			GROUP BY (task_id))ts ON ts.task_id = tasks.id",
							"tasks_basic_listing");
		$list->perPage = 5;	
		$list->addFilter("active");
		if($add_filter)
			$list->addFilter($add_filter);
		$list->sortEnabled = false;
		$list->execute();
		$list->displayColumn('name','meno');
		$list->displayColumn('text','text','text','<div id="textTask{id}" onclick="showHideTask({id})" style="cursor:pointer">{text}</div><div id="taskStorage{id}" style="display:none">{text2}</div>');
		$list->displayColumn('last_use','naposledy');
		$list->displayColumn('id','','unsortable',$actions);
		$list->numberingCharacter = "#";

		$stylizer1 = new listingStylizer; 
		$stylizer1->addFormatting(array("function",array("strip_tags","text",$page->user->getSetting('allowed_tags')),"text"));
		$stylizer1->addFormatting(array("function",array("shortenedText","text",$page->user->getSetting('task_list_text_length')),"text"));
		$stylizer1->addFormatting(array("function",array("dateFormat","last_use","to_display"),"last_use"));
		$stylizer1->addFormatting(array("css","width:140px","name"));
		$stylizer1->addCondition(array("1","==","1"));
		
		$ldf = new listingDataFormatting;
		$ldf->addStylizer($stylizer1);
		$list->renderer->setLDF($ldf);
		return $list;  	
  }
} 
?>