<?php
class studentListBox extends box {
	
	public function display(){
		$studentsTable = new studentsTable;
		$coursesTermsTable = new coursesTermsTable;
		$unassignedStudentsTable = new unassignedStudentsTable;
		$egTable = new excerciseGroupsTable;
		
		if($_GET['course_id'])
			$loaded = $coursesTermsTable->load($_GET['course_id']);
		else
			$loaded = $coursesTermsTable->loadDefault($this->page->user);

		//ZMENA PREDMETU
		if($_POST['submit_course']){
			$url = new url(array('course_id'=>$_POST['course_term']));
			$url->deleteParam("message_id");
			$this->page->redirect($url->makeUrl());
		}
		
		//PRIDAVANIE NOVEHO STUDENTA
		if($_POST['submit']){
			$studentsTable->set("name",$_POST['name']);
			$studentsTable->set("surname",$_POST['surname']);
			$studentsTable->set("email",$_POST['email']);
			if($studentsTable->add()){
				$unassignedStudentsTable->set('student_id',$studentsTable->get('id'));
				$unassignedStudentsTable->set('course_term_id',$coursesTermsTable->get('id'));
				$unassignedStudentsTable->set('confirmed',true);
				if($unassignedStudentsTable->add())
					$url = new url(array('message_id'=>1));
				else	
					$url = new url(array('message_id'=>2));	
			}
			else	
				$url = new url(array('message_id'=>2));
			$this->page->redirect($url->makeUrl());	
		}
		
		//PRIDAVANIE STUDENTA ZO SYSTEMU
		if($_POST['submit2'] && $studentsTable->load($_POST['studentsTableCombo'])){
			$unassignedStudentsTable->set('student_id',$studentsTable->get('id'));
			$unassignedStudentsTable->set('course_term_id',$coursesTermsTable->get('id'));
			$unassignedStudentsTable->set('confirmed',true);
			if($unassignedStudentsTable->add())
				$url = new url(array('message_id'=>3));
			else	
				$url = new url(array('message_id'=>4));		
			$this->page->redirect($url->makeUrl());	
		}
		if($loaded){
			$actions = "<a href='javascript:makeStudentEditable({id})' class='button'>edituj</a>";
			$actions .= "<a href='javascript:removeStudent({id})' class='button'>odstráň z predmetu</a>";
			$actions .= "<a href='javascript:confirmStudent({id})' class='button'>potvrď</a>";
			$list = new listing("SELECT sig_id, student_id AS id,student_name AS name,student_surname AS surname, 
								 student_email AS email, \"day\" AS eg, \"time\", place, confirmed
								 FROM students_groups_view WHERE NOT(student_id is null) AND course_term_id = ".$coursesTermsTable->get('id')." 
								 UNION
								 SELECT us.id as sig_id,s.id,s.name,s.surname,s.email,0,null,'',confirmed 
								 FROM unassigned_students AS us
								 INNER JOIN students AS s ON s.id=us.student_id",
								"students_listing");
			$list->perPage = 50;
			$list->setNoResultMessage("Žiadny študent v databáze");
			$list->sortEnabled = false;
			$list->setOrderBy("surname,name");
			$list->addFilter("us.course_term_id=".$coursesTermsTable->get('id'));
			$list->execute();
			$list->displayColumn('surname','priezvisko','surname',"<div id='surname_box_{id}'>{surname}</div>");
			$list->displayColumn('name','meno','name',"<div id='name_box_{id}'>{name}</div>");
			$list->displayColumn('email','e-mail','email',"<div id='email_box_{id}'>{email}</div>");
			$list->displayColumn('eg','skupina','eg',"<div id='eg_box_{id}'>{eg}</div><input type='hidden' name='sig_id_{id}' value='{sig_id}'/><input type='hidden' name='confirmed{id}' value='{confirmed}'/>");
			$list->displayColumn('id','akcia');
			$list->numberingCharacter = "#";
	
			$stylizer1 = new listingStylizer; 
			$stylizer1->addFormatting(array("css","background-color: #dfa699","all"));
			$stylizer1->addCondition(array("confirmed","==","f"));

			$stylizer2 = new listingStylizer; 
			$stylizer2->addFormatting(array("function",array("studentListBox::formatGroup","eg","time","place"),"eg"));
			$stylizer2->addFormatting(array("function",array("studentListBox::listingActions","id","confirmed"),"id"));
			$stylizer2->addCondition(array("1","==","1"));
	
			$ldf = new listingDataFormatting;
			$ldf->addStylizer($stylizer1);
			$ldf->addStylizer($stylizer2);
			$list->renderer->setLDF($ldf);				
	
			if($_GET['ajax']){
				echo $list->toHtml();
				exit;
			}
			$this->add("listing",$list);
			$this->add("groupsCombo",$egTable->getCombo('{day} {time} {place}',"id","course_term_id=".$coursesTermsTable->get("id"),"day"));
			$this->add("otherStudentsCombo",$studentsTable->getCombo('{surname} {name}',"id","NOT(id IN (SELECT student_id FROM unassigned_students WHERE course_term_id=".$coursesTermsTable->get("id").")) AND NOT(id IN (SELECT student_id FROM students_groups_view WHERE course_term_id=".$coursesTermsTable->get("id")."))","surname,name",true,"id='selectOtherStudents'"));			
		}
		
		$this->add("loaded",$loaded);
		$this->add("courseName",$coursesTermsTable->getName($this->page->user));
		$this->add("courseTerm",$coursesTermsTable);
		$this->add("message",$this->getMessage($_GET['message_id']));
		$this->add("coursesCombo",$coursesTermsTable->getCoursesCombo("course_term",$_GET['course_id'],$this->page->user));
		parent::display();
	}	

	//funkcia pouzita v stylizeri pripojeneho k listingu. 
	//vracia akcie. nepouziva sa ako pattern, pretoze jeden button moze mat dva rozne tvary
	//da tlacitko potvrdit, iba ak je student nepotvrdeny
	public function	listingActions($id,$confirmed){
		$actions = "<div id='action_box_$id'>";
		$actions .= "<a href='javascript:makeStudentEditable($id)' class='button'>edituj</a>";
		$actions .= "<a href='javascript:removeStudent($id)' class='button'>odstráň z predmetu</a>";
		if($confirmed=="f")
			$actions .= "<a href='javascript:confirmStudent($id)' class='button'>potvrď</a>";
		$actions .= "</div>";	
		return $actions;
	}

	//vracia text spravy po vykonani danej akcie
	public function getMessage($message_id){
		switch($message_id){
			case '1':
				$message = array("text"=>"Študent bol úspešne pridaný do databázy.",'type'=>"success");
			break;	
			case '2':
				$message = array("text"=>"Študenta sa nepodarilo pridať do databázy.",'type'=>"error");
			break;	
			case '3':
				$message = array("text"=>"Študent bol úspešne priradený k predmetu.",'type'=>"success");
			break;	
			case '4':
				$message = array("text"=>"Študenta sa nepodarilo priradiť k predmetu.",'type'=>"error");
			break;	

		}
		return $message;		
	}
	
	public function setTitle(){
		return "Administrácia študentov";
	}

	public function formatGroup($day,$time,$place){
		if($day==0)
			return "";
		else	
			return dayOfWeek($day)." ".substr($time,0,-3)." ".$place;
	}
}
?>
