<?php

///
///   Registrcia uvatea - kontrola udajov zadanych vo formulari
///

include 'iportalVseobecne.php';

set_error_handler("errorHandler");  // nastavenie handleru chyb
session_start();                    // sedenie

function stranka() {
    global $texty;
    
    uvodHTML('registracia',array(),'');
    zobrazitLogin();
    zobrazitHlasenie();
    
       oznamenie('regUziv');
       oznamenie('boloUsp');
        
    menu();       
    zaverHTML();
}// end function stranka

if (!session_is_registered('chyby')) { // registracia kontextu pre mon chyby
   session_register('chyby');
   } // if
$_SESSION['chyby'] = array(); // przdn pole chyb - zatial
if (!session_is_registered('premenneFormulara')) { // mus existovat registracia kontextu premennych formulra
   session_register('premenneFormulara');
   } // if
   
foreach($_POST as $menoPremennej => $hodnota) { // premenne formulara su predavane cez $_POST
   $_SESSION['premenneFormulara'][$menoPremennej] = trim(odstranenieEscape($hodnota, 150));
   } // foreach

// username
if (!session_is_registered('uid')) { // zatial neexistuje sedenie
    if (empty($_SESSION['premenneFormulara']["username"])) { // username nesmie byt przdny
       $_SESSION['chyby']["username"] = $texty['zapisatUdaj'];
       } // if meno
    elseif (!ereg("^(".$slovenskePismena."|['-])*$", $_SESSION['premenneFormulara']["username"])) { // username nesmie obsahovat biele znaky
       $_SESSION['chyby']["username"] = $texty['deravyUdaj'];
       } // elseif
    elseif (strlen($_SESSION['premenneFormulara']["username"]) > 50) { // username nesmie byt dlhsi, ako 50 znakov
       $_SESSION['chyby']["username"] = $texty['udajDo50'];
       } // elseif
    else { // kontrola, ci uz je rovnaky username v databaze
      $SRBD=spojenieSRBD();
      $vysledok=dotazSQL(sprintf($dotazy['overUsername'],$_SESSION['premenneFormulara']["username"]), $SRBD);  // dotaz na username
      if (mysql_num_rows($vysledok) >= 1) {
         $_SESSION['chyby']["username"] = $texty['userExistuje']; // username uz je v databze
         } // if >=1
      } // else
   } // if !session

// heslo
if (!session_is_registered('uid') &&
    (strlen($_SESSION['premenneFormulara']["heslo"]) < 4 ||
     strlen($_SESSION['premenneFormulara']["heslo"]) > 8) ||
     !ereg("^(".$slovenskePismena."|['-.\ \?\!\@\(\)\&\*\%\#\/\,\:\_]){4,8}$", $_SESSION['premenneFormulara']["heslo"])
    ) {
   $_SESSION['chyby']["heslo"] = $texty['formatPass']; // chybn heslo
   }
   
// opakovanie hesla
if (!session_is_registered('uid') &&
    ($_SESSION['premenneFormulara']["zopakHesla"] != $_SESSION['premenneFormulara']["heslo"] )) {
   $_SESSION['chyby']["zopakHesla"] = $texty['rovnakeHesla']; // chybn zopakovanie hesla
   }   

// meno
if (empty($_SESSION['premenneFormulara']["meno"])) { // meno nesmie byt przdne
   $_SESSION['chyby']["meno"] = $texty['zapisatUdaj'];
   } // if meno
elseif (!ereg("^(".$slovenskePismena."|['-])*$", $_SESSION['premenneFormulara']["meno"])) { // meno nesmie obsahovat biele znaky
   $_SESSION['chyby']["meno"] = $texty['deravyUdaj'];
   } // elseif
elseif (strlen($_SESSION['premenneFormulara']["meno"]) > 50) { // meno nesmie byt dlhsie, ako 50 znakov
   $_SESSION['chyby']["meno"] = $texty['udajDo50'];
   } // elseif

// priezvisko
if (empty($_SESSION['premenneFormulara']["priezvisko"])) { // priezvisko nesmie byt przdne
   $_SESSION['chyby']["priezvisko"] = $texty['zapisatUdaj'];
   } // if priezvisko
elseif (!ereg("^(".$slovenskePismena."|['-])*$", $_SESSION['premenneFormulara']["priezvisko"])) { // priezvisko nesmie obsahovat biele znaky
   $_SESSION['chyby']["priezvisko"] = $texty['deravyUdaj'];
   } // elseif
elseif (strlen($_SESSION['premenneFormulara']["priezvisko"]) > 50) { // priezvisko nesmie byt dlhsie, ako 50 znakov
   $_SESSION['chyby']["priezvisko"] = $texty['udajDo50'];
   } // elseif

//vek
if ((!empty($_SESSION['premenneFormulara']["vek"])) && (!ereg("^([0-9]{2})$", $_SESSION['premenneFormulara']["vek"]))) { // vek musi byt zlozeny max. z troch cisiel
   $_SESSION['chyby']["vek"] = $texty['zlyVek'];
   } // if
   
//fotka
$posiela = false;
if (isset($_FILES['fotka']) && ($_FILES['fotka']['name']!="")) { 
   $posiela = true;
   if ($_FILES['fotka']['error'] != UPLOAD_ERR_OK) {
     $_SESSION['chyby']["fotka"] = $texty['chybaPrenosu'];
     } // if
   if (!(($_FILES['fotka']['type'] == 'image/pjpeg') || 
             ($_FILES['fotka']['type'] == 'image/jpeg') || 
             ($_FILES['fotka']['type'] == 'image/gif'))) {
     $_SESSION['chyby']["fotka"] = $texty['zlyFormat'];
     } // elseif
   } // isset

if (count($_SESSION['chyby']) > 0)  { // boli chyby
   header('Location: '.$subory['registracia']); // nvrat k formulru na opravu chyb
   exit;
   } // if count
if (!isset($SRBD)) { // u sme pripojeni k databze
   $SRBD=spojenieSRBD();
   } // if

if (!session_is_registered('uid')) { // ide o INSERT
   $salt = substr($_SESSION['premenneFormulara']["username"], 0, 2); // prve 2 znaky username ako salt hesla
   $heslo = crypt($_SESSION['premenneFormulara']["heslo"], $salt); // zakdovanie hesla
   $dotaz=sprintf($dotazy['registracia'],
      $_SESSION['premenneFormulara']["username"],
      $heslo,
      $_SESSION['premenneFormulara']["meno"],
      $_SESSION['premenneFormulara']["priezvisko"],
      $_SESSION['premenneFormulara']["vek"],
      'fotky/fantom.jpg',
      0);
   } // if
$vysledok=dotazSQL($dotaz, $SRBD);  // urobit dotaz

if ($posiela && is_uploaded_file($_FILES['fotka']['tmp_name'])) {
    $cesta = 'fotky/'.$_SESSION['premenneFormulara']["username"].'.jpg'; //urcenie cesty k fotke
    $podarilosa = move_uploaded_file($_FILES['fotka']['tmp_name'], $cesta); //jej ulozenie do daneho priecinka
    $vysledok = dotazSQL(sprintf($dotazy['pridajFotku'],$cesta,$_SESSION['premenneFormulara']["username"]),$SRBD); 
  }

session_unregister('premenneFormulara');  // zruenie kontextu formulra
session_unregister('chyby'); // zruenie kontextu chyb
stranka();
?>
