<?php

///
///   Uvodna stranka - novinky, nove knihy pridane do databazy
///

include 'iportalVseobecne.php';
set_error_handler('errorHandler');
session_start(); 

// automaticky logout
if (session_is_registered('username')) {
    if (!session_is_registered('lastChange')) {
             session_register('lastChange');
             $_SESSION['lastChange'] = time();
        }
    if (time() - $_SESSION['lastChange'] >= 900) {
         header('Location: '.$subory['odhlasenie']);
         exit;
      }
    $_SESSION['lastChange'] = time();
  } // if registered
  
session_unregister('nadpis');  // zruenie kontextu nadpisu pre vyhladavanie
session_unregister('vyhladavanie'); // zruenie kontextu dotazu pre vyhladavanie

if (!ereg("^(".$slovenskePismena."|['-])*$", $_POST["username"])) { // username nesmie obsahovat biele znaky
       session_register('hlasenie'); // hlasenie
       $_SESSION['hlasenie'] = $texty['nesprUdaje'];
       } // elseif
if (!ereg("^(".$slovenskePismena."|['-])*$", $_POST["heslo"])) { // username nesmie obsahovat biele znaky
       session_register('hlasenie'); // hlasenie
       $_SESSION['hlasenie'] = $texty['nesprUdaje'];
       } // elseif   
   
if (isset($_POST["username"])) { // parameter uivatelsk meno cez POST
   $uzivatelskeMenoUsch = odstranenieEscape($_POST["username"], 50);
   } // if
if (isset($_POST["heslo"])) { // heslo cez POST
   $prihlasovacieHeslo = odstranenieEscape($_POST["heslo"], 15);
   } // if

if (!isset($uzivatelskeMenoUsch) ||  // bola tu chyba ale sme este nic nezadali
   !isset($prihlasovacieHeslo) ||
   session_is_registered('hlasenie')) {
      prihlasovaciaStranka();
   } // if 
else { // nebola chyba
   kontrolaPrihlasenia($uzivatelskeMenoUsch, $prihlasovacieHeslo);
   } // else   

function prihlasovaciaStranka() {
  
  // stranka ktora sa objavi na zaciatku
  global $texty;
  global $subory;
  global $dotazy;

  $zoznam = array ('zoradNajnovsieA','zoradNajnovsieD','zoradAutorA','zoradAutorD',
                   'zoradNazovA','zoradNazovD','zoradVydavatelA','zoradVydavatelD',
                   'zoradZanerA','zoradZanerD','zoradPocetKomD','zoradPocetKomA',
                   'zoradCelkHodnA','zoradCelkHodnD','zoradPocHlasovA','zoradPocHlasovD');

  uvodHTML('knihyVDat',array(),'');
  zobrazitLogin();
  
       echo  
         '<H2'.
         '>'."\n".
            $texty['knihyVDat'].
         '</H2>'."\n";  
        zobrazitHlasenie();
         $dotaz = 'vyhladaj';
         if (isset($_GET["offset"])) { // je v parametroch offset
                 $offset = odstranenieEscape($_GET["offset"], 5);
                 } // if
             else { // inak je 0
                 $offset = 0;
                 } // else
         if (isset($_GET["zorad"])) { // je v parametroch zorad
                   if (in_array($_GET["zorad"],$zoznam)) {
                      $zorad = $_GET["zorad"];
                      $get = 'zorad='.$_GET["zorad"];
                      if (($_GET["zorad"] == 'zoradPocetKomD') || ($_GET["zorad"] == 'zoradPocetKomA')) {
                        $dotaz = 'najdiskutovanejsie';
                        }
                   }
                 } // if
             else { // inak je 0
                 $zorad = 'zoradNajnovsieD';
                 } // else
         $SRBD=spojenieSRBD();
         celaTabulka("",$dotazy[$dotaz].$dotazy[$zorad],$SRBD,$offset,$subory['index'],$get,"panel");
         
  menu();       
  zaverHTML();
}  // of prihlasovaciaStranka

function kontrolaPrihlasenia($uzivatelskeMeno, $prihlasovacieHeslo) {
   // kontrola prihlasenia
   //
   // vstupne parametre:  $uzivatelskeMeno
   //                     $prihlasovacieHeslo
   // nvratov hodnota:  nieje
   // globlne premenne:
   global $texty;
   global $subory;
   global $dotazy;

   $salt = substr($uzivatelskeMeno, 0, 2); // dva prve znaky z mena pre zakdovanie hesla
   $zakodovaneHeslo = crypt($prihlasovacieHeslo, $salt); // zakdovanie hesla
   $SRBD=spojenieSRBD();
   $vysledok=dotazSQL(sprintf($dotazy['prihlasUziv'],$uzivatelskeMeno,$zakodovaneHeslo), $SRBD);  // urobit dotaz

   if (mysql_num_rows($vysledok) == 1) { // prve jeden riadok je sprvne najdenie uivatela
      $row = mysql_fetch_assoc($vysledok);
      session_register('username'); 
      $_SESSION['username']=$uzivatelskeMeno;
      session_register('meno'); 
      $_SESSION['meno']=$row['meno'];
      session_register('priezvisko'); 
      $_SESSION['priezvisko']=$row['priezvisko'];
      session_register('vek'); 
      $_SESSION['vek']=$row['vek'];
      session_register('fotka'); 
      $_SESSION['fotka']=$row['fotka'];
      session_register('uid'); 
      $_SESSION['uid']=$row['uid']; 
      session_register('admin'); 
      $_SESSION['admin']=$row['admin'];  
      if (session_is_registered('chyby')) { // odregistracia pripadnho kontextu chyb
         session_unregister('chyby');
         } // if
      if (session_is_registered('premenneFormulara')) { // odregistracia pripadnho kontextu premennch formulara
         session_unregister('premenneFormulara');
         } // if
         prihlasovaciaStranka();
      } // if prve jeden riadek
   else  { // nie je prave jeden riadok, uzivatel nie je zaregistrovany
      if (session_is_registered('username')) { // odregistracia pripadnho kontextu uivatela
         session_unregister('username');
         session_unregister('meno'); 
         session_unregister('priezvisko'); 
         session_unregister('uid'); 
         session_unregister('vek');
         session_unregister('fotka');
         } // if
      session_register('hlasenie'); // hlsenie
      $_SESSION['hlasenie'] = $texty['nesprUdaje'];
      prihlasovaciaStranka();
      } // else
} // of kontrolaPrihlasenia

?>
