﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AUDIOTEKA
{
    public partial class AddArtist : System.Web.UI.UserControl
    {
        DataClassesDataContext _db = new DataClassesDataContext();

        protected void Page_Load(object sender, EventArgs e)
        {
            LabelExists.Visible = false;
            LabelRequired.Visible = false;
            LabelSuccess.Visible = false;
        }

        private void clearInput()
        {
            TextBoxFirstName.Text = "";
            TextBoxLastName.Text = "";
            TextBoxInfo.Text = "";
            TextBoxHomepage.Text = "";
        }

        protected void Button_Click(object sender, EventArgs e)
        {
            int nArtists = (from art in _db.Artists
                            where (art.FirstName == TextBoxFirstName.Text) & (art.LastName == TextBoxLastName.Text)
                            select art).Count();

            if (nArtists == 0)
            {
                if ((TextBoxFirstName.Text != "") | (TextBoxLastName.Text != ""))
                {
                    Artist NewArtist = new Artist();

                    NewArtist.FirstName = TextBoxFirstName.Text;
                    NewArtist.LastName = TextBoxLastName.Text;
                    NewArtist.Info = TextBoxInfo.Text;
                    NewArtist.HomePage = TextBoxHomepage.Text;

                    _db.Artists.InsertOnSubmit(NewArtist);
                    _db.SubmitChanges();

                    clearInput();
                    LabelSuccess.Visible = true;

                }
                else
                {
                    LabelRequired.Visible = true;
                }
            }
            else
            {
                LabelExists.Visible = true;
            }
        }
    }
}