﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace AUDIOTEKA
{
    public class AlbumItem : Album
    {
        private string _ArtistName;
        private string _ArtistLastName;
        private string _GenreName;

        public string FilterArtist { get; set; }

        public string FilterGenre { get; set; }

        public string ArtistLastName
        {
            get
            {
                return this._ArtistLastName;
            }
            set
            {
                if ((this._ArtistLastName != value))
                {
                    this._ArtistLastName = value;
                }
            }
        }
        public string ArtistName
        {
            get
            {
                return this._ArtistName;
            }
            set
            {
                if ((this._ArtistName != value))
                {
                    this._ArtistName = value;
                }
            }
        }
        public string GenreName
        {
            get
            {
                return this._GenreName;
            }
            set
            {
                if ((this._GenreName != value))
                {
                    this._GenreName = value;
                }
            }
        }

    }


    public class AlbumItems
    {
        public static IEnumerable<AlbumItem> Select()
        {
            DataClassesDataContext db = new DataClassesDataContext();

            return (from alb in db.Albums

                    join g in db.Genres
                    on alb.GenreId equals g.GenreId

                    join art in db.Artists
                    on alb.ArtistId equals art.ArtistId

                    select new AlbumItem { ArtistLastName = art.LastName, ArtistName = (art.FirstName + " " + art.LastName), GenreName = g.GenreName, AlbumId = alb.AlbumId, AlbumName = alb.AlbumName, ArtistId = alb.ArtistId, GenreId = alb.GenreId, PicturePresent = alb.PicturePresent, Year = alb.Year }).OrderBy(a => a.ArtistLastName).ThenBy(a => a.Year);
        }

        public static IEnumerable<AlbumItem> SelectPage(int? FilterArtistId, int? FilterGenreId, string Search, string SortExpression, int startRowIndex, int maximumRows)
        {
            IEnumerable<AlbumItem> result = Select();
            bool ascending = !SortExpression.EndsWith("DESC");
            SortExpression = SortExpression.Replace(" DESC", "");

            result = FilterItems(result, FilterArtistId, FilterGenreId, Search);

            switch (SortExpression)
            {
                case "AlbumName":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.AlbumName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.AlbumName);
                    }
                    break;

                case "Year":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.Year).ThenBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.Year).ThenBy(p => p.ArtistLastName);
                    }

                    break;

                case "ArtistName":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.ArtistLastName);
                    }

                    break;

                case "GenreName":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.GenreName).ThenBy(p => p.ArtistLastName).ThenBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.GenreName).ThenBy(p => p.ArtistLastName);
                    }

                    break;

                default:
                    break;
            }

            return result.Skip(startRowIndex).Take(maximumRows);
        }

        public static IEnumerable<AlbumItem> FilterItems(IEnumerable<AlbumItem> result, int? FilterArtistId, int? FilterGenreId, string Search)
        {
            if (FilterArtistId.HasValue & FilterArtistId > 0)
            {
                result = result.Where(p => p.ArtistId == FilterArtistId);
            }

            if (FilterGenreId.HasValue & FilterGenreId > 0)
            {
                result = result.Where(p => p.GenreId == FilterGenreId);
            }

            if ((Search != null) & (Search != ""))
            {
                result = result.Where(p => (p.AlbumName.ToLower().Contains(Search.ToLower()) | p.ArtistName.ToLower().Contains(Search.ToLower())));
            }

            return result;
        }

        public static int SelectCount(int? FilterArtistId, int? FilterGenreId, string Search)
        {
            IEnumerable<AlbumItem> result;
            result = Select();

            result = FilterItems(result, FilterArtistId, FilterGenreId, Search);

            return result.Count();
        }
        public static void DeleteAlbum(int AlbId)
        {

        }
    }
}
