﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;

namespace AUDIOTEKA
{
    public partial class ManageAlbums : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Artist> _Artists;
        IEnumerable<Genre> _Genres;

        protected void initDDLists()
        {
            ArtistDDList.DataSource = _Artists;
            ArtistDDList.DataValueField = "ArtistId";
            ArtistDDList.DataTextField = "LastName";
            ArtistDDList.DataBind();

            GenreDDList.DataSource = _Genres;
            GenreDDList.DataValueField = "GenreId";
            GenreDDList.DataTextField = "GenreName";
            GenreDDList.DataBind();
        }


        protected void Page_Load(object sender, EventArgs e)
        {
            EditPlaceHolder.Visible = false;
            FalseLabel.Visible = false;
            RequiredLabel.Visible = false;
            SuccessLabel.Visible = false;

            _Artists = from art in _db.Artists
                       orderby art.LastName ascending
                       select art;

            _Genres = from g in _db.Genres
                      orderby g.GenreName ascending
                      select g;

            if (!Page.IsPostBack)
            {
                initDDLists(); // inicializuje hodnoty v dropdown listoch
            }


            if (!Page.IsPostBack)
            {
                EditArtistDDList.DataSource = _Artists;
                EditArtistDDList.DataTextField = "LastName";
                EditArtistDDList.DataValueField = "ArtistId";
                EditArtistDDList.DataBind();

                EditGenreDDList.DataSource = _Genres;
                EditGenreDDList.DataTextField = "GenreName";
                EditGenreDDList.DataValueField = "GenreId";
                EditGenreDDList.SelectedValue = "105";
                EditGenreDDList.DataBind();
                EditAlbumNameTextBox.Text = "";
                EditYearTextBox.Text = "";
            }
        }

        protected void AlbumGridView_RowDelete(object sender, GridViewDeleteEventArgs e)
        {
            Album AlbumToDelete;

            int AlbumId = (int)AlbumsGridView.DataKeys[e.RowIndex].Value;

            try
            {
                AlbumToDelete = (from album in _db.Albums
                                 where album.AlbumId == AlbumId
                                 select album).First();

                _db.Albums.DeleteOnSubmit(AlbumToDelete);
                _db.SubmitChanges();
            }
            catch (Exception)
            {
            }

        }

        protected void ObjectDataSource_DeleteMethod(object sender, ObjectDataSourceMethodEventArgs e)
        {
            IDictionary paramsFromPage = e.InputParameters;

            paramsFromPage.Remove("AlbId");
            paramsFromPage.Add("AlbId", (int)paramsFromPage["AlbumId"]);
            paramsFromPage.Remove("AlbumId");

        }

        protected void AlbumGridView_RowEdit(object sender, GridViewSelectEventArgs e)
        {
            EditHiddenField.Value = "";

            int AlbumId = (int)AlbumsGridView.DataKeys[e.NewSelectedIndex].Value;

            Album AlbumToEdit = null;

            try
            {
                AlbumToEdit = (from album in _db.Albums
                               where album.AlbumId == AlbumId
                               select album).First();
            }
            catch (Exception)
            {
                AlbumToEdit = null;
            }

            if (AlbumToEdit != null)
            {
                EditPlaceHolder.Visible = true;
                EditNadpis.InnerText = "Úprava albumu: " + AlbumToEdit.AlbumName;
                EditHiddenField.Value = AlbumId.ToString();

                EditAlbumNameTextBox.Text = AlbumToEdit.AlbumName;
                EditArtistDDList.SelectedValue = AlbumToEdit.ArtistId.ToString();
                EditGenreDDList.SelectedValue = AlbumToEdit.GenreId.ToString();
                EditYearTextBox.Text = AlbumToEdit.Year.ToString();

            }
        }

        protected void ArtistGridView_PageChanged(object sender, GridViewPageEventArgs e)
        {
            AlbumsGridView.PageIndex = e.NewPageIndex;
            AlbumsGridView.DataBind();
        }

        protected void EditAlbumButton_Click(object sender, EventArgs e)
        {

            //int ArtistCount = (from artist in _db.Artists
            //                   where artist.LastName == EditLastNameBox.Text & artist.FirstName == EditFirstNameBox.Text
            //                   select artist).Count();


            Album AlbumToEdit = null;

            try
            {
                AlbumToEdit = (from album in _db.Albums
                               where album.AlbumId.ToString() == EditHiddenField.Value.ToString()
                               select album).First();
            }
            catch (Exception)
            {
                AlbumToEdit = null;
            }

            if ((EditAlbumNameTextBox.Text != ""))
            {
                if (AlbumToEdit != null)
                {
                    AlbumToEdit.AlbumName = EditAlbumNameTextBox.Text;
                    AlbumToEdit.ArtistId = Convert.ToInt32(EditArtistDDList.SelectedValue);
                    AlbumToEdit.GenreId = Convert.ToInt32(EditGenreDDList.SelectedValue);
                    if (EditYearTextBox.Text == "")
                    {
                        AlbumToEdit.Year = null;
                    }
                    else
                    {
                        AlbumToEdit.Year = Convert.ToInt32(EditYearTextBox.Text);
                    }


                    _db.SubmitChanges();
                    EditPlaceHolder.Visible = false;
                    AlbumsGridView.DataBind();
                }

                EditPlaceHolder.Visible = false;
            }
            else
            {
                RequiredLabel.Visible = true;
            }
        }
    }
}
