﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AUDIOTEKA
{

    public partial class ManageGenres : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Genre> _data;

        protected void LoadData()
        {
            _data = from genre in _db.Genres
                    orderby genre.GenreName ascending
                    select genre;
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            LoadData();

            GenresGridView.DataSource = _data;
            GenresGridView.DataBind();

            Label_GenreExists.Visible = false;
            EditGenreExistsLabel.Visible = false;
            if (!Page.IsPostBack)
            {
                EditPlaceHolder.Visible = false;
            }
        }

        protected void GenresGridView_RowDelete(object sender, GridViewDeleteEventArgs e)
        {
            Genre GenreToDelete = null;

            int GenreId = (int)GenresGridView.DataKeys[e.RowIndex].Value;


            try
            {
                GenreToDelete = (from g in _db.Genres
                                 where g.GenreId == GenreId
                                 select g).First();
            }
            catch (Exception)
            {
                GenreToDelete = null;
            }


            if (GenreToDelete != null)
            {
                _db.Genres.DeleteOnSubmit(GenreToDelete);
                _db.SubmitChanges();
            }

            LoadData();
            GenresGridView.DataSource = _data;
            GenresGridView.DataBind();

        }

        protected void GenresGridView_RowEdit(object sender, GridViewEditEventArgs e)
        {
            EditHiddenField.Value = "";

            int GenreId = (int)GenresGridView.DataKeys[e.NewEditIndex].Value;

            Genre GenreToEdit = (from g in _db.Genres
                                 where g.GenreId == GenreId
                                 select g).First();

            if (GenreToEdit != null)
            {
                EditPlaceHolder.Visible = true;
                EditNadpis.InnerText = "Úprava žánru " + GenreToEdit.GenreName;
                EditHiddenField.Value = GenreId.ToString();
                EditGenreExistsLabel.Visible = false;
                EditGenreBox.Text = GenreToEdit.GenreName;
            }
        }

        protected void GenresGridView_PageChanged(object sender, GridViewPageEventArgs e)
        {
            GenresGridView.PageIndex = e.NewPageIndex;
            GenresGridView.DataBind();
        }

        protected void AddGenreButton_Click(object sender, EventArgs e)
        {

            if (GenreBox.Text != "")
            {

                Genre newGenre;
                int gcount = (from g in _db.Genres
                              where g.GenreName == GenreBox.Text
                              select g).Count();

                if (gcount == 0)
                {
                    newGenre = new Genre();
                    newGenre.GenreName = GenreBox.Text;

                    _db.Genres.InsertOnSubmit(newGenre);
                    _db.SubmitChanges();

                    LoadData();
                    GenresGridView.DataSource = _data;
                    GenresGridView.DataBind();

                    GenreBox.Text = "";

                }
                else
                {
                    Label_GenreExists.Visible = true;
                }
            }
        }
        protected void EditGenreButton_Click(object sender, EventArgs e)
        {

            int gcount = (from g in _db.Genres
                          where g.GenreName == EditGenreBox.Text
                          select g).Count();

            if (gcount == 0)
            {
                Genre GenreToEdit = (from g in _db.Genres
                                     where g.GenreId.ToString() == EditHiddenField.Value.ToString()
                                     select g).First();

                if (GenreToEdit != null)
                {
                    GenreToEdit.GenreName = EditGenreBox.Text;
                    _db.SubmitChanges();
                    EditPlaceHolder.Visible = false;
                }

                LoadData();
                GenresGridView.DataSource = _data;
                GenresGridView.DataBind();
                EditPlaceHolder.Visible = false;
            }
            else
            {
                EditGenreExistsLabel.Visible = true;
            }

        }


    }
}
