﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;

namespace AUDIOTEKA
{
    public class MyAlbumItem : PersonalAlbum
    {
        private string _ArtistName;
        private string _ArtistLastName;
        private string _GenreName;
        private string _AlbumName;
        private System.Nullable<int> _ArtistId;
        private System.Nullable<int> _GenreId;
        private System.Nullable<int> _Year;

        public System.Nullable<int> ArtistId
        {
            get
            {
                return this._ArtistId;

            }
            set
            {
                if ((this._ArtistId != value))
                {
                    this._ArtistId = value;
                }
            }
        }

        public System.Nullable<int> GenreId
        {
            get
            {
                return this._GenreId;

            }
            set
            {
                if ((this._GenreId != value))
                {
                    this._GenreId = value;
                }
            }
        }

        public System.Nullable<int> Year
        {
            get
            {
                return this._Year;

            }
            set
            {
                if ((this._Year != value))
                {
                    this._Year = value;
                }
            }
        }
        public string AlbumName
        {
            get
            {
                return this._AlbumName;
            }
            set
            {
                if ((this._AlbumName != value))
                {
                    this._AlbumName = value;
                }
            }
        }
        public string ArtistName
        {
            get
            {
                return this._ArtistName;
            }
            set
            {
                if ((this._ArtistName != value))
                {
                    this._ArtistName = value;
                }
            }
        }
        public string ArtistLastName
        {
            get
            {
                return this._ArtistLastName;
            }
            set
            {
                if ((this._ArtistLastName != value))
                {
                    this._ArtistLastName = value;
                }
            }
        }
        public string GenreName
        {
            get
            {
                return this._GenreName;
            }
            set
            {
                if ((this._GenreName != value))
                {
                    this._GenreName = value;
                }
            }
        }

    }


    public class MyAlbumItems
    {
        public static IEnumerable<MyAlbumItem> Select()
        {

            MembershipUser myUser = Membership.GetUser();
            Guid UserID = (Guid)myUser.ProviderUserKey;

            DataClassesDataContext db = new DataClassesDataContext();

            return from myAlb in db.PersonalAlbums

                   join alb in db.Albums
                   on myAlb.AlbumId equals alb.AlbumId

                   join g in db.Genres
                   on alb.GenreId equals g.GenreId

                   join art in db.Artists
                   on alb.ArtistId equals art.ArtistId

                   where myAlb.UserId == UserID

                   orderby art.LastName ascending
                   orderby alb.Year ascending

                   select new MyAlbumItem { ArtistId = art.ArtistId, GenreId = g.GenreId, ArtistLastName = art.LastName, Year = alb.Year, ArtistName = art.FirstName + " " + art.LastName, UserId = myAlb.UserId, GenreName = g.GenreName, AlbumId = alb.AlbumId, AlbumName = alb.AlbumName, Quality = myAlb.Quality, Rating = myAlb.Rating, StorageMedium = myAlb.StorageMedium };
        }

        public static IEnumerable<MyAlbumItem> SelectPage(int? FilterArtistId, int? FilterGenreId, string FilterStorage, string Search, string SortExpression, int startRowIndex, int maximumRows)
        {
            IEnumerable<MyAlbumItem> result = Select();
            bool ascending = !SortExpression.EndsWith("DESC");
            SortExpression = SortExpression.Replace(" DESC", "");

            result = FilterItems(result, FilterArtistId, FilterGenreId, FilterStorage, Search);

            switch (SortExpression)
            {
                case "AlbumName":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.AlbumName).ThenBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.AlbumName).ThenBy(p => p.ArtistLastName);
                    }
                    break;

                case "Year":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.Year).ThenBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.Year).ThenBy(p => p.ArtistLastName);
                    }

                    break;

                case "ArtistName":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.ArtistName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.ArtistName);
                    }

                    break;

                case "GenreName":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.GenreName).ThenBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.GenreName).ThenBy(p => p.ArtistLastName);
                    }

                    break;
                case "Quality":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.Quality).ThenBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.Quality).ThenBy(p => p.ArtistLastName);
                    }

                    break;
                case "Rating":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.Rating).ThenBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.Rating).ThenBy(p => p.ArtistLastName);
                    }

                    break;

                case "StorageMedium":
                    if (ascending)
                    {
                        result = result.OrderBy(p => p.StorageMedium).ThenBy(p => p.ArtistLastName);
                    }
                    else
                    {
                        result = result.OrderByDescending(p => p.StorageMedium).ThenBy(p => p.ArtistLastName);
                    }

                    break;
                default:
                    break;
            }


            //  return Select().Skip(startRowIndex).Take(maximumRows);

            return result;

        }

        public static IEnumerable<MyAlbumItem> FilterItems(IEnumerable<MyAlbumItem> result, int? FilterArtistId, int? FilterGenreId, string FilterStorage, string Search)
        {
            if (FilterArtistId.HasValue & FilterArtistId > 0)
            {
                result = result.Where(p => p.ArtistId == FilterArtistId);
            }

            if (FilterGenreId.HasValue & FilterGenreId > 0)
            {
                result = result.Where(p => p.GenreId == FilterGenreId);
            }

            if (FilterStorage != "" & FilterStorage != null)
            {
                result = result.Where(p => p.StorageMedium == FilterStorage);
            }

            if ((Search != null) & (Search != ""))
            {
                result = result.Where(p => (p.AlbumName.ToLower().Contains(Search.ToLower()) | p.ArtistName.ToLower().Contains(Search.ToLower())));
            }

            return result;
        }

        public static int SelectCount(int? FilterArtistId, int? FilterGenreId, string FilterStorage, string Search)
        {
            return FilterItems(Select(), FilterArtistId, FilterGenreId, FilterStorage, Search).Count();
        }

        public static void DeleteAlbum(int AlbId)
        {

        }

    }
}
