﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AUDIOTEKA
{
    public partial class AlbumDetail : System.Web.UI.Page
    {
        Album _Album = null;
        DataClassesDataContext _db = new DataClassesDataContext();

        protected void Page_Load(object sender, EventArgs e)
        {

            try
            {
                _Album = (from a in _db.Albums
                          where a.AlbumId.ToString() == Request["albid"]
                          select a).First();
            }
            catch (Exception)
            {
            }

            if (_Album != null)
            {
                header.InnerText = "Detail albumu " + _Album.AlbumName;

                AlbumNameLabel.Text = _Album.AlbumName;
                AlbumYearLabel.Text = _Album.Year.ToString();

                try
                {
                    Artist AlbumArtist = (from g in _db.Artists
                                          where g.ArtistId == _Album.ArtistId
                                          select g).First();
                    AlbumAutorLabel.Text = AlbumArtist.FirstName + " " + AlbumArtist.LastName;
                }
                catch (Exception)
                {
                    AlbumAutorLabel.Text = "N/A";
                }

                try
                {
                    Genre AlbumGenre = (from g in _db.Genres
                                        where g.GenreId == _Album.GenreId
                                        select g).First();
                    AlbumGenreLabel.Text = AlbumGenre.GenreName;
                }
                catch (Exception)
                {
                    AlbumGenreLabel.Text = "N/A";
                }


                double priemer = 0;
                IEnumerable<string> rated = from a in _db.PersonalAlbums
                                            where a.AlbumId == _Album.AlbumId & a.Rating != null
                                            select a.Rating;

                foreach (string item in rated)
                {
                    try
                    {
                        priemer = priemer + Convert.ToInt32(item);
                    }
                    catch (Exception)
                    {
                    }
                }

                if (rated.Count() > 0)
                {
                    priemer = priemer / rated.Count();
                    AlbumRankLabel.Text = priemer.ToString();
                }
                else {
                    AlbumRankLabel.Text = "N/A";
                }
            }
            else
            {
                header.InnerText = "Detail albumu neexistuje";
            }
        }
    }
}
