﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security;

namespace AUDIOTEKA
{
    public partial class AlbumPage : System.Web.UI.Page
    {
        DataClassesDataContext _db = new DataClassesDataContext();
        IEnumerable<Artist> _Artists;
        IEnumerable<Genre> _Genres;

        protected void initDDLists()
        {
            ArtistDDList.DataSource = _Artists;
            ArtistDDList.DataValueField = "ArtistId";
            ArtistDDList.DataTextField = "LastName";
            ArtistDDList.DataBind();

            GenreDDList.DataSource = _Genres;
            GenreDDList.DataValueField = "GenreId";
            GenreDDList.DataTextField = "GenreName";
            GenreDDList.DataBind();

        }

        protected void GridRefresh(object sender, EventArgs e)
        {
            AlbumsGridView.DataBind();
            AlbumsDataSource.DataBind();
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            _Artists = from art in _db.Artists
                       orderby art.LastName ascending
                       select art;

            _Genres = from g in _db.Genres
                      orderby g.GenreName ascending
                      select g;

            if (!Page.IsPostBack)
            {
                initDDLists(); // inicializuje hodnoty v dropdown listoch

                Form.Action = "AlbumPage.aspx";
            }

            LabelMissing.Visible = false;
            LabelAlready.Visible = false;
            LabelSuccess.Visible = false;

            // zobrazenie stlpca na pridavanie albumov do sukromneho zoznamu
            if (User.IsInRole("user"))
            {
                AlbumsGridView.Columns[4].Visible = true;
            }
            else
            {
                AlbumsGridView.Columns[4].Visible = false;
            }

            if (Request["Genre"] != null)
            {
                SetGenreFilter(Request["Genre"].ToString());
            }

            if (Request["Artist"] != null)
            {
                SetArtistFilter(Request["Artist"].ToString());
            }
        }

        protected void SetGenreFilter(string GenreToSelect)
        {
            if ((GenreToSelect == null) | (GenreToSelect == ""))
            {
                return;
            }

            try
            {
                Genre SelectedGenre = (from g in _db.Genres
                                       where g.GenreName == GenreToSelect
                                       select g).First();
                if (SelectedGenre != null)
                {
                    GenreDDList.SelectedValue = SelectedGenre.GenreId.ToString();
                }
            }
            catch (Exception)
            {
            }
        }

        protected void SetArtistFilter(string ArtistToSelect)
        {
            if ((ArtistToSelect == null) | (ArtistToSelect == ""))
            {
                return;
            }

            try
            {
                Artist SelectedArtist = (from g in _db.Artists
                                         where g.LastName == ArtistToSelect
                                         select g).First();

                if (SelectedArtist != null)
                {
                    ArtistDDList.SelectedValue = SelectedArtist.ArtistId.ToString();
                }
            }
            catch (Exception)
            {
            }
        }

        protected void GridView_RowSelect(object sender, GridViewSelectEventArgs e)
        {
            if (User.IsInRole("user"))
            {
                PersonalAlbum addAlbum;
                int itemID = (int)AlbumsGridView.DataKeys[e.NewSelectedIndex].Value;

                int Acount = (from a in _db.Albums
                              where a.AlbumId.ToString() == itemID.ToString()
                              select a).Count();

                MembershipUser myUser = Membership.GetUser();
                Guid UserID = (Guid)myUser.ProviderUserKey;

                int PersonalAlbumcount = (from a in _db.PersonalAlbums
                                          where a.AlbumId.ToString() == itemID.ToString() & a.UserId == UserID
                                          select a).Count();

                if (Acount == 1)
                {
                    if (PersonalAlbumcount == 0)
                    {
                        addAlbum = new PersonalAlbum();
                        addAlbum.AlbumId = Convert.ToInt32(itemID.ToString());

                        addAlbum.UserId = UserID;

                        _db.PersonalAlbums.InsertOnSubmit(addAlbum);
                        _db.SubmitChanges();

                        LabelSuccess.Visible = true;

                    }
                    else
                    {
                        LabelAlready.Visible = true;
                    }

                }
                else
                {
                    LabelMissing.Visible = true;
                }


            }
        }

    }
}
