using System;
using System.Data;
using System.Data.Linq;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Linq;

public partial class testy : System.Web.UI.Page {

    private NorthwindDataContext db = new NorthwindDataContext();
    private Table<test> ttesty = null;
    private Table<CategoryTestQuestionRelation> test_relacie = null;
    private Table<category> kategorie = null;
    private Table<aspnet_User> uzivatelia = null;

    protected void Page_Init(object sender, EventArgs e) {
        //adding CSS style file
        HtmlLink newCSS = new HtmlLink();
        newCSS.Href = "~/css/testy_style.css";
        newCSS.Attributes.Add("type", "text/css");
        newCSS.Attributes.Add("rel", "Stylesheet");
        Page.Header.Controls.Add(newCSS);
        //create tables
        this.ttesty = db.GetTable<test>();
        this.kategorie = db.GetTable<category>();
        this.test_relacie = db.GetTable<CategoryTestQuestionRelation>();
        this.uzivatelia = db.GetTable<aspnet_User>();
    }

    protected void Page_Load(object sender, EventArgs e) {
        if (!Page.IsPostBack) {
            var out_testy =
                from t in this.ttesty
                let link = "~/main/test.aspx?id=" + t.test_id
                select new { link = link, title = t.title };
            testy_list.DataSource = out_testy;
            testy_list.DataBind();
            // kategorie_select
            var out_kat =
                from c in this.kategorie
                from kc in this.test_relacie
                where c.category_id == kc.category_id
                select c.title;
            category_select.DataSource = out_kat;
            category_select.DataBind();
            category_select.Items.Add("vetky");
            category_select.SelectedValue = "vetky";
            var out_users =
                from c in this.ttesty
                select c.user_name;
            user_select.DataSource = out_users;
            user_select.DataBind();
            user_select.Items.Add("vetci");
            user_select.SelectedValue = "vetci";
        }
    }
    protected void category_select_SelectedIndexChanged(object sender, EventArgs e) {
 
    }
    protected void user_select_SelectedIndexChanged(object sender, EventArgs e) {

    }
}
