<?php
/**
 * @author Ivan
 */
class Maintenance extends Controller
{

    public function main()
    {

        try {
            $tpl['categories'] = Models\Category::all();
            $tpl['register']   = Models\Register::all();
        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $contents = array(
            load_viewer( 'maintenance/parts.tpl.php', $tpl ),
            'Pomocka'
        );

        $tpl['parts_html']    = LayoutHelpers\get_contents_tab( 'category_table', array('Content', 'Help'), $contents, 'Vyhladávanie v záznamoch' );
        $tpl['register_html'] = load_viewer( 'maintenance/register.tpl.php', $tpl );
        
        if ( has_user_rights_for($this->user, __CLASS__, 'do_maintenance') ) {

            $tpl['action_link'] = $this->loop_url_back_to_controller( 'do_maintenance' );
            $output = load_viewer( 'maintenance/main.tpl.php', $tpl);
        }
        else {

            $output = $tpl['parts_html'] . $tpl['register_html'];

        }

        return $output;
    }

    public function do_maintenance()
    {
        $template_id = filter_input( INPUT_POST, 'template', FILTER_SANITIZE_STRING );

        $categories = array();
        $copies     = array();
        
        foreach ( $_POST as $key => $value ) {
            if ( 'CC_' == substr( $key, 0, 3 ) ) {
                $copies[] = $value;
            }
            elseif ( 'CL_' == substr( $key, 0, 3 ) ) {
                $cat = explode( '_', substr($key, 3) );
                $categories[$cat[0]][] = $cat[1];
            }
        }



        try {
            $to_delete = array();
            $parts     = array();
            foreach ( $categories as $category => $subcategories ) {
                $conditions = array( 'register_id IN (?) AND category_id = ? AND subcategory_id IN (?)', $copies, $category, $subcategories );
                $to_delete  = array_merge( $to_delete, Models\Part::all( array( 'conditions' => $conditions ) ) );

                $conditions = array( 'register_id = ? AND category_id = ? AND subcategory_id IN (?)', $template_id, $category, $subcategories );
                $parts  = array_merge( $parts , Models\Part::all( array( 'conditions' => $conditions  ) ) );
            }
        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        foreach ($to_delete as $row) {
            $row->delete();
        }

        foreach ($copies as $copy) {
            foreach ( $parts as $part ) {
                $new_part = new Models\Part();

                $new_part->register_id    = $copy;
                $new_part->category_id    = $part->category_id;
                $new_part->subcategory_id = $part->subcategory_id;
                $new_part->count          = $part->count;
                $new_part->number         = $part->number;
                $new_part->oe_number      = $part->oe_number;
                $new_part->note           = $part->note;

                try {
                    $new_part->save();
                } catch (Exception $e) {
                    SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
                    throw $e;
                }
            }
        }

        return 'ok';

    }


    public function exploitation()
    {
        $categories = Models\Category::all();

        
        foreach ( $categories as $category) {

                $params['conditions'] = array('number != "" AND category_id = ?', $category->id);
                $params['group']      = 'number, category_id';
                $params['order']      = '2 desc';
                $params['select']     = 'count(*) AS count, sum(count) as suma, number, oe_number';

                try {
                    $parts[$category->id] = array('name'  => $category->name,
                                                  'parts' => Models\Part::all( $params ) );
                } catch (Exception $e) {
                    SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
                    throw $e;
                }

        }

        $tpl['parts'] = $parts;

        return load_viewer( 'maintenance/exploitation.tpl.php', $tpl);
    }

    public function part_occurence()
    {

        $part_number    = filte_input( INPUT_GET, 'number'   , FILTER_SANITIZE_STRING );
        $part_oe_number = filte_input( INPUT_GET, 'oe_number', FILTER_SANITIZE_STRING );

        $parts = Models\Part::find_all_by_number_or_oe_number( $part_number, $part_oe_number );

        $tpl['parts'] = $parts;

        return load_viewer($filename, $tpl);
        echo "<pre>";
        var_dump($parts);
        echo "</pre>";
        exit();
    }
}
?>