<?php
/**
 * @author Ivan
 */
class RegisterSearch extends Controller
{

    public function show_list()
    {

        $contents = array(
            load_viewer( 'register/register_search.tpl.php', $tpl ),
            'Pomocnik'
        );

        $tpl['search'] = LayoutHelpers\get_contents_tab( 'manage_rights', array('Content', 'Help'), $contents, 'Rights Management ' . $controller );

        return load_viewer('register/register_main.tpl.php', $tpl);
    }

    public function save_part()
    {

        $register_id    = filter_input( INPUT_POST, 'register'   , FILTER_SANITIZE_NUMBER_INT );
        $category_id    = filter_input( INPUT_POST, 'category'   , FILTER_SANITIZE_NUMBER_INT );
        $subcategory_id = filter_input( INPUT_POST, 'subcategory', FILTER_SANITIZE_NUMBER_INT );
        $part_id        = filter_input( INPUT_POST, 'part'       , FILTER_VALIDATE_INT ) ? $_POST['part'] : 0;

        $count     = filter_input( INPUT_POST, 'count', FILTER_SANITIZE_NUMBER_INT );
        $number    = filter_input( INPUT_POST, 'number', FILTER_SANITIZE_STRING     );
        $oe_number = filter_input( INPUT_POST, 'oe_number', FILTER_SANITIZE_STRING     );

        $output = array();

        try {

            if ( $part_id > 0 ) {
                $part = Models\Part::find( $part_id );
            }
            else{
                $part = new Models\Part();
            }

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            $output['result'] = 0;
            $output['id']     = 0;

            echo json_encode( $output );
            exit();
        }

        $part->register_id      = $register_id;
        $part->category_id      = $category_id;
        $part->subcategory_id   = $subcategory_id;
        $part->count            = $count;
        $part->number           = $number;
        $part->oe_number        = $oe_number;

        if ( $part->save() ) {
            $output['result'] = 1;
            $output['id']     = $part->id;
        }
        else {
            $output['result'] = 0;
            $output['id']     = 0;
        }

        echo json_encode( $output );
        exit();
    }

    public function get_subcategories()
    {

        $register_id = filter_input( INPUT_POST, 'register_id', FILTER_SANITIZE_NUMBER_INT );
        $category_id = filter_input( INPUT_POST, 'category_id', FILTER_SANITIZE_NUMBER_INT );

        $params['conditions'] =  array('register_id = ? AND category_id = ?', $register_id, $category_id);
        $params['order']      =  'subcategory_id asc';

        try {

            $subcategories      = Models\Subcategory::find( 'all', array( 'conditions' => array('category_id = ?', $category_id), 'order' => 'id asc' ) );
            $subcategories_data = Models\Part::find( 'all', $params );

        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            echo LayoutHelpers\get_notification_error($e->getMessage());
            exit();
        }

        $output_data = array();

        $tpl['save_link'] = $this->loop_url_back_to_controller( 'save_part' );

        if ( ! is_array( $subcategories_data ) ) {

            foreach ( $subcategories as $subcategory ) {

                $output_data[] = array(
                    'category' => $subcategory,
                    'data'     => null
                );

            }

            $tpl['data'] = $output_data;
            echo load_viewer( 'register/subcategories.tpl.php', $tpl );
            exit();

        }


        foreach ( $subcategories as $key => $subcategory ) {

                $output_data[$key] = array();

                foreach ( $subcategories_data as $data ) {

                    if( $data->subcategory_id == $subcategory->id ) {

                        $output_data[$key] = array(
                            'category' => $subcategory,
                            'data'     => $data
                        );

                    }

                }

                if ( empty ( $output_data[$key] ) ) {
                    $output_data[$key] = array(
                        'category' => $subcategory,
                        'data'     => null
                    );
                }

        }

        $tpl['save_option'] = has_user_rights_for($this->user, __CLASS__, 'save_part');
        $tpl['data'] = $output_data;
        echo load_viewer( 'register/subcategories.tpl.php', $tpl );
        exit();
    }

    public function show_parts()
    {

        if( ! filter_input( INPUT_POST, 'register_id', FILTER_VALIDATE_INT ) ) {
            echo "!";
            exit();
        }

        $tpl['register_id'] = filter_input( INPUT_POST, 'register_id', FILTER_SANITIZE_NUMBER_INT );

        try {
            $tpl['categories'] = Models\Category::all();
            $tpl['record']     = Models\Register::find( $tpl['register_id'] );
        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $tpl['link_subcategories'] = $this->loop_url_back_to_controller( 'get_subcategories' );

        echo load_viewer( 'register/parts_list.tpl.php', $tpl);
        exit();

    }

    public function get_note()
    {
        $register =  Models\Register::find( filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT) );
        echo $register->note;
        exit();
    }

    public function datatable()
    {

        $params['select'] = 'r.id as id, 
                             r.spz as spz,
                             r.vin as vin,
                             b.name AS brand,
                             t.name AS type,
                             e.name AS engine,
                             o.name AS owner';
        
        $params['from'] = 'register AS r';
        $params['joins'] = array(
            'LEFT JOIN brands  b  ON ( r.brand_id = b.id )',
            'LEFT JOIN types   t  ON ( r.type_id  = t.id )',
            'LEFT JOIN engines e  ON ( r.engine_id  = e.id )',
            'LEFT JOIN owners  o  ON ( r.owner_id  = o.id )'
        );

        try {

            $data = LayoutHelpers\datatable_prepare( new Models\Register(), $params );
            
        } catch (Exception $e) {
            SystemError::log_error( __FILE__, __CLASS__, __FUNCTION__, __LINE__, $e->getMessage());
            throw $e;
        }

        $data['headers'] = array( 'ID', 'ŠPZ', 'VIN', 'Značka', 'Typ', 'Motor', 'Majiteľ / Spoločnosť', 'Poznámka' );
        $data['loopback'] = $this->loop_url_back_to_controller( 'datatable' );
        $data['link_url1'] = $this->loop_url_back_to_controller( 'get_note', 'id=' );

        $data['parts_link'] = has_user_rights_for($this->user, __CLASS__, 'show_parts') ? $this->loop_url_back_to_controller( 'show_parts' ) : '';

        $contents = array(
            LayoutHelpers\datatable_load( $data ),
            'Pomocka'
        );

        $tpl['content'] = LayoutHelpers\get_contents_tab( 'datatable_table', array('Content', 'Help'), $contents, 'Vyhladávanie v záznamoch' );

        return load_viewer( 'register/register.tpl.php', $tpl);
    }
}

?>
