<?php
namespace Models;

class UsersGroupsRight extends \ActiveRecord\Model
{
    static $belongs_to = array(
        array( 'subsection', 'class_name' => 'Models\GroupsSubsection' )
    );

    /**
     * @desc Returns array with the names of controllers
     */
    public static function get_controllers()
    {
        $params['select'] = "DISTINCT(controller) ";
        $params['conditions'] = 'method != ""';
        $params['order'] = "controller";
        $params['limit'] = 0;

        try {
            $controllers = UsersGroupsRight::find('all',$params);
        }
        catch (Exception $e) {
            echo "<hr /><pre>";
            var_dump('LINE : '. __LINE__ . ' | FILE : ' . __FILE__);
            var_dump($e->getMessage());
            echo "</pre><hr />";
        }

        $resutl = array();
        foreach ( $controllers as $controller ) {
            $result[] = $controller->controller;
        }

        return $result;
    }
}
?>