<?php
class VideoklipyController extends Zend_Controller_Action {

	private $messanger;
    public function init()
    {
    	$this->messanger =  $this->_helper->getHelper('FlashMessenger');
    	
        /* Initialize action controller here */
    }

    public function indexAction()
    {
    	$page = $this->_request->getParam('strana');
    	if(empty($page)){
    		$page = 1;
    	}
    	$this->view->title = 'Toto je mo title';
    	$tmp = new Model_DbTable_Videoklipy(); 
    	$statement = $tmp->select()->limitPage($page, 12);
    	$this->view->videoklipy = $tmp->fetchAll($statement);
    	$paginator = Zend_Paginator::factory($tmp->fetchAll());
    	$paginator->setItemCountPerPage(12);
    	$paginator->setCurrentPageNumber($page);
    	$this->view->paginator=$paginator;	
    }
    
    public function viewAction(){
    	$id = $this->_request->getParam('id');    	
    	if(!empty($id)){
    		if(!ctype_digit($id)){
    	       $yt = new Zend_Gdata_YouTube();
    		   $result = $yt->getVideoEntry($id); 
    		   $objekt['id'] = $result->getVideoId();  
    		   $objekt['url'] =  $id;
    		   $objekt['img'] = $result->mediaGroup->thumbnail[0]->url;
    		   $objekt['name'] = $result->mediaGroup->title;    		   	
    		   $this->view->videoklip = $objekt;  
    		   $this->view->related = $this->getRelated($id);  		    		      
    		}else{
    		  $video = new Model_DbTable_Videoklipy();
    		  $result = $video->getVideoKlip((int)$id);
    		  $objekt['id'] = $result->id;
    		  $objekt['name'] = $result->title;
    		  $objekt['url'] = $result->url;
    		  $objekt['img'] = 'data/'.date('d-m-Y').'/'.$result->url.'.jpg';
    		  $this->view->related = $this->getRelated($objekt['url']);    		   
    		  $this->view->videoklip = $objekt;
    		}    	
    	}else{
    		$this->messanger->addMessage(array('typ' => 'error', 'sprava' => 'Neplatne zadane ID Akcie'));
    	}
    }
    
    public function addAction(){
    	$auth = Zend_Auth::getInstance();
    	$logged = $auth->hasIdentity();
        if(!$logged){
    		$this->_redirect('/');
    	}
    	$user_info = $auth->getStorage()->read();
    	$id=  $this->_request->getParam('id');
    	if(!empty($id)){
    		$yt = new Zend_Gdata_YouTube();
    		$result = $yt->getVideoEntry($id);   
    		$video_url =  $result->mediaGroup->player[0]->url;
    		$thumb_url = $result->mediaGroup->thumbnail[0]->url;	    		
    		$this->view->info = $video_url;
    		$this->view->thumb = $this->downloadThumb($video_url, $thumb_url); 
    		$nadpis = $result->getTitle();
				$data = array(
    			  'active' => 1, 
    			  'title' => $nadpis,
    			  'url' => $id,
    			  'category' => 0,
    			  'date' => new Zend_Db_Expr('NOW()') 
    			); 
    			$videoklip = new Model_DbTable_Videoklipy();
    			$statement = $videoklip->select()->where('url = ?', $id);
    			$test = $videoklip->fetchRow($statement);    			
    			if(count($test) == 0){
    			  $klip_id = $videoklip->insert($data);
    			}else{
    				$klip_id = $test->id;
    			}
    			
    			$user_playlist = new Model_DbTable_Playlist();
    			$user_playlist->insert(array('klip_id' => $klip_id, 'user_id' => $user_info->id));
    			$this->_redirect('/uzivatel/playlist');    		
    	}else{
    		$this->messanger->addMessage(array('typ' => 'error', 'sprava' => 'Neplatne zadana query'));
    	}
    }
    
    public function postDispatch(){
    	$this->view->messages = $this->messanger->getMessages();
    }
    
    private function downloadThumb($video_url, $thumb_url){
    	$pos = strpos($video_url, 'v=');
    	$video = substr($video_url, $pos +2 );
    	$pos = strpos($video, '&');
    	$video = substr($video,0,$pos);
    	$date = date('d-m-Y');	
    	$YourFile = $thumb_url;

		$Data = file_get_contents($YourFile);
		    			
		$myFile01 = "data/".$date;
		if(!file_exists($myFile01)){
			mkdir($myFile01, 777);
		}
		$myFile = "data/".$date."/".$video.".jpg";		
		file_put_contents($myFile, $Data);

    	$thumb = substr($url, strpos($url, '?v='+3), 10);
    	return $thumb;
    }
    
    public function searchAction(){
    	$q = $this->_request->getParam('q');
    	if(!empty($q) && isset($q)){
    		$yt = new Zend_Gdata_YouTube();    		    
    		$query = $yt->newVideoQuery();
    		$query->setQuery($q);
    		$query->setStartIndex(1);
    		$query->setMaxResults(20);
    		$feed = $yt->getVideoFeed($query);
    		//$this->view->klipy = $feed;
    		
    		$result = array();
    		foreach ($feed as $klip){
    			$tmp = array();
    			$tmp['id'] = $klip->getVideoId();
    			$tmp['img'] = $klip->mediaGroup->thumbnail[0]->url;
    			$tmp['name'] = $klip->title;
    			$result[] = $tmp;
    		}
    		
    		$this->view->klipy = $result;
           
    	}else{
    		$this->view->klipy = array();
    	}
    }
    
    private function getRelated($videoID){    	
    	$yt = new Zend_Gdata_YouTube();
    	$ytQuery = $yt->newVideoQuery(); 
    	$ytQuery->setFeedType('related', $videoID);
    	$ytQuery->setOrderBy('rating');
        $ytQuery->setMaxResults(8);
    	$ytQuery->setFormat(5);
    	return $yt->getVideoFeed($ytQuery);    	    	
    }
}
?>