<? 
/*
		GPS Share v.1
    Copyright (C) 2010  Filip Vojtko

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

function data_comments($id,$lang)
{
	if (!(is_int((int)$id)))
		return false;
		
	$comments_query = "SELECT C.id AS id, C.time AS time, C.text AS text, U.login as author FROM comments AS C NATURAL JOIN (SELECT id AS author, login FROM users) AS U WHERE C.placemark = ".db_safe_string($id)." ORDER BY C.time DESC";
	
	if (!($comments_res = db_query($comments_query)))
		return false;
		
	include_once($lang);
		
	header("Content-type: text/xml");
	echo '<?xml version="1.0" encoding="UTF-8"?>';
	echo '<comment_export>';
	if (db_num_rows($comments_res) == 0)
		echo $comments_lang['20'];
	while ($comments = db_fetch_array($comments_res))
	{
		echo "<comment_data>";
			echo "<author>".htmlspecialchars($comments['author'])."</author>";
			echo "<author-lang>".$comments_lang['22']."</author-lang>";
			echo "<text>".htmlspecialchars($comments['text'])."</text>";
			echo "<date>".htmlspecialchars($comments['time'])."</date>";			
			echo "<date-lang>".$comments_lang['23']."</date-lang>";
			echo "<id>".htmlspecialchars($comments['id'])."</id>";
			echo "<lang>".$comments_lang['9']."</lang>";
		echo "</comment_data>";
	}
	echo '</comment_export>';
	die();
	return true;
}

function add_comment($text,$placemark)
{
	if (!auth_islogged())
		return false;
	
	$text = htmlspecialchars($text);
		
	if (strlen($text) < 1)
		return false;
	
	if (!(is_int((int)$placemark)))
		return false;
	
	$text = db_safe_string($text);
	$placemark = db_safe_string($placemark);
	
	$add_query = "INSERT INTO comments (placemark,author,text,time) VALUES ('$placemark','".db_safe_string(auth_userid())."','$text',NOW())";
	if (!db_query($add_query))
		return false;
	
	return true; 
}

function comments_delete($id)
{
	if (auth_usertype() != '1')
		return false;
	
	if (!is_int((int)$id))
		return false;
		
	if (db_query("DELETE FROM comments WHERE id = '".db_safe_string($id)."';"))
		return true;
		
	return false;	
}

function show_comments($lang) 
{
	include_once($lang);
	
	if (!(is_int((int)$_GET['showcomments'])))
		return;
	
	$placemark_query = "SELECT P.name AS name,P.place_country AS country,P.gps_longitude AS longitude,P.gps_latitude AS latitude,P.gps_altitude AS altitude,CE.state AS state,TE.type_name AS type,U.login AS author ";
	$placemark_query .= "FROM placemarks AS P NATURAL JOIN (SELECT id AS author, login FROM users) AS U NATURAL JOIN (SELECT id AS place_state, name AS state FROM country_enumerator) AS CE NATURAL JOIN (SELECT id AS type, name AS type_name FROM placemark_type_enumerator) AS TE ";
	$placemark_query .= "WHERE P.id = ".db_safe_string($_GET['showcomments']);
	
	if ((!($placemark_res = db_query($placemark_query))) OR (db_num_rows($placemark_res) == 0))
		return;
	
	if (!($placemark = db_fetch_array($placemark_res)))
		return;
	
	?>
	<h1>
		<? echo $placemark['name'];?>
	</h1>
	
	<div id="placemark_details">
		<table>
			<tr>
				<td>
					<span id="placemark_details_name_legend"><?echo $comments_lang['10'];?></span>	
				</td>
				<td>
					<span class="placemark_details_data" id="placemark_details_name"><?echo $placemark['name'];?></span>
				</td>
			</tr>
			<tr>
				<td>
					<span id="placemark_details_type_legend"><?echo $comments_lang['11'];?></span>
				</td>
				<td>
					<span class="placemark_details_data" id="placemark_details_type"><?echo $placemark['type'];?></span>
				</td>
			</tr>
			<tr>
				<td>
					<span id="placemark_details_longitude_legend"><?echo $comments_lang['12'];?></span>
				</td>
				<td>
					<span class="placemark_details_data" id="placemark_details_longitude"><?echo $placemark['longitude'];?></span>
				</td>
			</tr>
			<tr>
				<td>
					<span id="placemark_details_latitude_legend"><?echo $comments_lang['13'];?></span>
				</td>
				<td>
					<span class="placemark_details_data" id="placemark_details_latitude"><?echo $placemark['latitude'];?></span>
				</td>
			</tr>
			<tr>
				<td>
					<span id="placemark_details_altitude_legend"><?echo $comments_lang['14'];?></span>
				</td>
				<td>
					<span class="placemark_details_data" id="placemark_details_altitude"><?echo $placemark['altitude'];?></span>
				</td>
			</tr>
			<tr>
				<td>
					<span id="placemark_details_country_legend"><?echo $comments_lang['15'];?></span>
				</td>
				<td>
					<span class="placemark_details_data" id="placemark_details_country"><?echo $placemark['country'];?></span>
				</td>
			</tr>
			<tr>
				<td>
					<span id="placemark_details_state_legend"><?echo $comments_lang['16'];?></span>
				</td>
				<td>
					<span class="placemark_details_data" id="placemark_details_state"><?echo $placemark['state'];?></span>
				</td>
			</tr>
			<tr>
				<td>
					<span id="placemark_details_author_legend"><?echo $comments_lang['17'];?></span>
				</td>
				<td>
					<span class="placemark_details_data" id="placemark_details_author"><?echo $placemark['author'];?></span>
				</td>
			</tr>
		</table>
	</div>

<?if (auth_islogged())
	{ ?>
		<span class="hide_show_button" id="comments_add_form_show" onclick='showForm("comments_add_form_set","comments_add_form_show");'><? echo "+ ".$comments_lang['2'];?></span>
		<form action="" enctype="multipart/form-data" method="post" id="comments_add_form">
			<fieldset id="comments_add_form_set">
					<legend><? echo $comments_lang['2'];?></legend>
					
					<label for="comments_add_text"><? echo $comments_lang['3'];?></label>
					<input type="text" id="comments_add_text" name="comments_add_text" maxlength="255" title=<? echo "\"".$comments_lang['3']."\"";?> <? if (isset($_POST['comments_add_text'])) echo "value=\"".htmlspecialchars($_POST['comments_add_text'])."\"";?> />
																
					<input type="submit" name="comments_add" title=<? echo "\"".$comments_lang['4']."\"";?> value=<? echo "\"".$comments_lang['4']."\"";?>	/>						
					
					<?
					if (isset($_POST['comments_add']))
					{
						if (isset($_POST['comments_add_text']))
						{
							if (strlen($_POST['comments_add_text']) < 1)
							{ ?>
								<span class="form_error"><? echo $comments_lang['5']; ?></span>
					<?	}						
							else if (!add_comment($_POST['comments_add_text'],$_GET['showcomments']))
							{ ?>
								<span class="form_error"><? echo $comments_lang['6']; ?></span>
					<?	}
							else
							{ ?>
								<span class="form_ok"><? echo $comments_lang['7']; ?></span>
					<?	//unset($_POST);
							}
						}				
					}
					
					?>
					
			</fieldset>
		</form>
		
		<script type="text/javascript">
	<? if (!(isset($_POST['comments_add'])))
			echo 'hideForm("comments_add_form_set","comments_add_form_show");';
	?>
		</script>
<?}?>
	
	<form action="" enctype="multipart/form-data" method="post" id="comments_show_form">
		<fieldset>
				<legend><? echo $comments_lang['8'];?></legend>	
								
<?	if (isset($_POST['comments_delete']))
		{
			if (comments_delete(htmlspecialchars($_POST['comments_delete'])))
					{ ?>
						<span class="form_ok"><? echo $comments_lang['18']; ?></span>
			 <? }
			 		else
			 		{ ?>
				 		<span class="form_error"><? echo $comments_lang['19']; ?></span>
	<?			}
		}	
		
		$comments_query = "SELECT C.id AS id, C.author AS author_id, C.time AS time, C.text AS text, U.login as author FROM comments AS C NATURAL JOIN (SELECT id AS author, login FROM users) AS U WHERE C.placemark = ".db_safe_string($_GET['showcomments'])." ORDER BY C.time DESC";
	
		if (!($comments_res = db_query($comments_query)))
			return;  ?>
		<div class="comments"	id="comments_place">
	<?	if (db_num_rows($comments_res) == 0)
				echo "<span id='no_comments'>".$comments_lang['20']."</span>";
			
			while($comments = db_fetch_array($comments_res))
			{ ?>
				<div class="comment_box" name="comment_box">				
					<span class="comment_author"><?echo $comments["author"];?></span>
					<span class="comment_author_lang"><?echo $comments_lang['22'];?></span>					
					<span class="comment_text"><?echo $comments["text"];?></span>
					<span class="comment_date_lang"><?echo $comments_lang['23'];?></span>				
					<span class="comment_date"><?echo $comments["time"];?></span>					
		<?	if (auth_usertype() == '1')
				{
				?>				
					<button type="submit" name="comments_delete" title=<? echo "\"".$comments_lang['9']."\"";?> value=<? echo "\"".$comments['id']."\"";?>><? echo $comments_lang['9'];?></button>							
	<?		} ?>			
				</div>
	<?	}  
	
						
	?>
		</div>
		<a href=<? echo "\"?showcomments=".$_GET['showcomments']."\"";?> id="comments_refresh" title=<? echo "\"".$comments_lang['21']."\"";?> ><? echo $comments_lang['21'];?></a>
		</fieldset>
	</form>
	
	<script type="text/javascript">
	<? if (auth_usertype() == '1')
	   { ?>
				getNewData(<? echo $_GET['showcomments'];?>,true);	
	<? } 
		 else
		 { ?>
				getNewData(<? echo $_GET['showcomments'];?>,false);	
	<? } ?>	
	</script>
	<?		
	
}



?>